/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider;

import java.util.Set;
import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;
import org.springframework.security.oauth2.common.exceptions.InvalidScopeException;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientCredentialsChecker {
    private final ClientDetailsService clientDetailsService;

    public ClientCredentialsChecker(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }

    public AuthorizationRequest validateCredentials(String grantType, String clientId) {
        return this.validateCredentials(grantType, clientId, null);
    }

    public AuthorizationRequest validateCredentials(String grantType, String clientId, Set<String> scopes) {
        ClientDetails clientDetails = this.clientDetailsService.loadClientByClientId(clientId);
        this.validateGrantType(grantType, clientDetails);
        if (scopes != null) {
            this.validateScope(clientDetails, scopes);
        }
        return new AuthorizationRequest(clientId, scopes, clientDetails.getAuthorities(), clientDetails.getResourceIds());
    }

    private void validateScope(ClientDetails clientDetails, Set<String> scopes) {
        if (clientDetails.isScoped()) {
            Set<String> validScope = clientDetails.getScope();
            if (scopes.isEmpty()) {
                throw new InvalidScopeException("Invalid scope (none)", validScope);
            }
            for (String scope : scopes) {
                if (validScope.contains(scope)) continue;
                throw new InvalidScopeException("Invalid scope: " + scope, validScope);
            }
        }
    }

    private void validateGrantType(String grantType, ClientDetails clientDetails) {
        Set<String> authorizedGrantTypes = clientDetails.getAuthorizedGrantTypes();
        if (authorizedGrantTypes != null && !authorizedGrantTypes.isEmpty() && !authorizedGrantTypes.contains(grantType)) {
            throw new InvalidGrantException("Unauthorized grant type: " + grantType);
        }
    }
}

