/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseClientDetails
implements ClientDetails {
    private String clientId;
    private String clientSecret;
    private Set<String> scope = Collections.emptySet();
    private Set<String> resourceIds = Collections.emptySet();
    private Set<String> authorizedGrantTypes = Collections.emptySet();
    private String registeredRedirectUri;
    private List<GrantedAuthority> authorities = Collections.emptyList();
    private int accessTokenValiditySeconds = 0;

    public BaseClientDetails() {
    }

    public BaseClientDetails(String commaSeparatedResourceIds, String commaSeparatedScopes, String commaSeparatedAuthorizedGrantTypes, String commaSeparatedAuthorities) {
        Set scopeList;
        Set resourceIds;
        if (StringUtils.hasText((String)commaSeparatedResourceIds) && !(resourceIds = StringUtils.commaDelimitedListToSet((String)commaSeparatedResourceIds)).isEmpty()) {
            this.resourceIds = resourceIds;
        }
        if (StringUtils.hasText((String)commaSeparatedScopes) && !(scopeList = StringUtils.commaDelimitedListToSet((String)commaSeparatedScopes)).isEmpty()) {
            this.scope = scopeList;
        }
        this.authorizedGrantTypes = StringUtils.hasText((String)commaSeparatedAuthorizedGrantTypes) ? StringUtils.commaDelimitedListToSet((String)commaSeparatedAuthorizedGrantTypes) : new HashSet<String>(Arrays.asList("authorization_code", "refresh_token"));
        if (StringUtils.hasText((String)commaSeparatedAuthorities)) {
            this.authorities = AuthorityUtils.commaSeparatedStringToAuthorityList((String)commaSeparatedAuthorities);
        }
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public boolean isSecretRequired() {
        return this.clientSecret != null;
    }

    @Override
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Override
    public boolean isScoped() {
        return this.scope != null && !this.scope.isEmpty();
    }

    @Override
    public Set<String> getScope() {
        return this.scope;
    }

    public void setScope(Collection<String> scope) {
        this.scope = new LinkedHashSet<String>(scope);
    }

    @Override
    public Set<String> getResourceIds() {
        return this.resourceIds;
    }

    public void setResourceIds(Collection<String> resourceIds) {
        this.resourceIds = new LinkedHashSet<String>(resourceIds);
    }

    @Override
    public Set<String> getAuthorizedGrantTypes() {
        return this.authorizedGrantTypes;
    }

    public void setAuthorizedGrantTypes(Collection<String> authorizedGrantTypes) {
        this.authorizedGrantTypes = new LinkedHashSet<String>(authorizedGrantTypes);
    }

    @Override
    public String getRegisteredRedirectUri() {
        return this.registeredRedirectUri;
    }

    public void setRegisteredRedirectUri(String registeredRedirectUri) {
        this.registeredRedirectUri = registeredRedirectUri;
    }

    @Override
    public Collection<GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public void setAuthorities(Collection<GrantedAuthority> authorities) {
        this.authorities = new ArrayList<GrantedAuthority>(authorities);
    }

    @Override
    public int getAccessTokenValiditySeconds() {
        return this.accessTokenValiditySeconds;
    }

    public void setAccessTokenValiditySeconds(int accessTokenValiditySeconds) {
        this.accessTokenValiditySeconds = accessTokenValiditySeconds;
    }
}

