/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.common.util.OAuth2Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationRequest
implements Serializable {
    private static final String CLIENT_ID = "client_id";
    private static final String STATE = "state";
    private static final String SCOPE = "scope";
    private static final String REDIRECT_URI = "redirect_uri";
    private static final String RESPONSE_TYPE = "response_type";
    private final Set<String> scope;
    private final Set<String> resourceIds;
    private final boolean approved;
    private final Collection<GrantedAuthority> authorities;
    private final Map<String, String> parameters = new HashMap<String, String>();

    public AuthorizationRequest(Map<String, String> parameters) {
        this(parameters.get(CLIENT_ID), OAuth2Utils.parseParameterList(parameters.get(SCOPE)), null, null, false, parameters.get(STATE), parameters.get(REDIRECT_URI));
        this.parameters.putAll(parameters);
    }

    public AuthorizationRequest(String clientId, Collection<String> scope, Collection<GrantedAuthority> authorities, Collection<String> resourceIds) {
        this(clientId, scope, authorities, resourceIds, true, null, null);
    }

    private AuthorizationRequest(AuthorizationRequest copy, boolean approved) {
        this(copy.getClientId(), copy.scope, copy.authorities, copy.resourceIds, approved, copy.getState(), copy.getRedirectUri());
        this.parameters.putAll(copy.parameters);
    }

    private AuthorizationRequest(String clientId, Collection<String> scope, Collection<GrantedAuthority> authorities, Collection<String> resourceIds, boolean approved, String state, String requestedRedirect) {
        this.resourceIds = resourceIds == null ? null : Collections.unmodifiableSet(new HashSet<String>(resourceIds));
        this.scope = scope == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(scope));
        this.authorities = authorities == null ? null : new HashSet<GrantedAuthority>(authorities);
        this.approved = approved;
        this.parameters.put(CLIENT_ID, clientId);
        this.parameters.put(STATE, state);
        this.parameters.put(REDIRECT_URI, requestedRedirect);
        this.parameters.put(SCOPE, OAuth2Utils.formatParameterList(scope));
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String getClientId() {
        return this.parameters.get(CLIENT_ID);
    }

    public Set<String> getScope() {
        return this.scope;
    }

    public Set<String> getResourceIds() {
        return this.resourceIds;
    }

    public Collection<GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public boolean isApproved() {
        return this.approved;
    }

    public boolean isDenied() {
        return !this.approved;
    }

    public AuthorizationRequest approved(boolean approved) {
        return new AuthorizationRequest(this, approved);
    }

    public AuthorizationRequest resolveRedirectUri(String redirectUri) {
        AuthorizationRequest result = new AuthorizationRequest(this, this.approved);
        result.parameters.put(REDIRECT_URI, redirectUri);
        return result;
    }

    public String getState() {
        return this.parameters.get(STATE);
    }

    public String getRedirectUri() {
        return this.parameters.get(REDIRECT_URI);
    }

    public Set<String> getResponseTypes() {
        return OAuth2Utils.parseParameterList(this.parameters.get(RESPONSE_TYPE));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.authorities == null ? 0 : ((Object)this.authorities).hashCode());
        result = 31 * result + (this.approved ? 1231 : 1237);
        result = 31 * result + (this.parameters == null ? 0 : ((Object)this.parameters).hashCode());
        result = 31 * result + (this.resourceIds == null ? 0 : ((Object)this.resourceIds).hashCode());
        result = 31 * result + (this.scope == null ? 0 : ((Object)this.scope).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthorizationRequest other = (AuthorizationRequest)obj;
        if (this.authorities == null ? other.authorities != null : !((Object)this.authorities).equals(other.authorities)) {
            return false;
        }
        if (this.approved != other.approved) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !((Object)this.parameters).equals(other.parameters)) {
            return false;
        }
        if (this.resourceIds == null ? other.resourceIds != null : !((Object)this.resourceIds).equals(other.resourceIds)) {
            return false;
        }
        return !(this.scope == null ? other.scope != null : !((Object)this.scope).equals(other.scope));
    }
}

