/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.http.converter;

import java.io.IOException;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormOAuth2AccessTokenMessageConverter
extends AbstractHttpMessageConverter<OAuth2AccessToken> {
    private final FormHttpMessageConverter delegateMessageConverter = new FormHttpMessageConverter();

    public FormOAuth2AccessTokenMessageConverter() {
        super(MediaType.APPLICATION_FORM_URLENCODED);
    }

    protected boolean supports(Class<?> clazz) {
        return OAuth2AccessToken.class.equals(clazz);
    }

    protected OAuth2AccessToken readInternal(Class<? extends OAuth2AccessToken> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        MultiValueMap data = this.delegateMessageConverter.read(null, inputMessage);
        return OAuth2AccessToken.valueOf(data.toSingleValueMap());
    }

    protected void writeInternal(OAuth2AccessToken accessToken, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        throw new UnsupportedOperationException("This converter is only used for converting from externally aqcuired form data");
    }
}

