/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.common.exceptions;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;
import org.springframework.security.oauth2.common.exceptions.InvalidRequestException;
import org.springframework.security.oauth2.common.exceptions.InvalidScopeException;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.common.exceptions.RedirectMismatchException;
import org.springframework.security.oauth2.common.exceptions.UnauthorizedClientException;
import org.springframework.security.oauth2.common.exceptions.UnsupportedGrantTypeException;
import org.springframework.security.oauth2.common.exceptions.UnsupportedResponseTypeException;
import org.springframework.security.oauth2.common.exceptions.UserDeniedAuthorizationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuth2ExceptionDeserializer
extends JsonDeserializer<OAuth2Exception> {
    public OAuth2Exception deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String errorMessage;
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            t = jp.nextToken();
        }
        HashMap<String, String> errorParams = new HashMap<String, String>();
        while (t == JsonToken.FIELD_NAME) {
            String fieldName = jp.getCurrentName();
            t = jp.nextToken();
            String value = t == JsonToken.VALUE_NULL ? null : jp.getText();
            errorParams.put(fieldName, value);
            t = jp.nextToken();
        }
        String errorCode = (String)errorParams.get("error");
        String string = errorMessage = errorParams.containsKey("error_description") ? (String)errorParams.get("error_description") : null;
        if (errorMessage == null) {
            String string2 = errorMessage = errorCode == null ? "OAuth Error" : errorCode;
        }
        OAuth2Exception ex = "invalid_client".equals(errorCode) ? new InvalidClientException(errorMessage) : ("unauthorized_client".equals(errorCode) ? new UnauthorizedClientException(errorMessage) : ("invalid_grant".equals(errorCode) ? new InvalidGrantException(errorMessage) : ("invalid_scope".equals(errorCode) ? new InvalidScopeException(errorMessage) : ("invalid_token".equals(errorCode) ? new InvalidTokenException(errorMessage) : ("invalid_request".equals(errorCode) ? new InvalidRequestException(errorMessage) : ("redirect_uri_mismatch".equals(errorCode) ? new RedirectMismatchException(errorMessage) : ("unsupported_grant_type".equals(errorCode) ? new UnsupportedGrantTypeException(errorMessage) : ("unsupported_response_type".equals(errorCode) ? new UnsupportedResponseTypeException(errorMessage) : ("access_denied".equals(errorCode) ? new UserDeniedAuthorizationException(errorMessage) : new OAuth2Exception(errorMessage))))))))));
        Set entries = errorParams.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            if ("error".equals(key) || "error_description".equals(key)) continue;
            ex.addAdditionalInformation(key, (String)entry.getValue());
        }
        return ex;
    }
}

