/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.common.exceptions;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;
import org.springframework.security.oauth2.common.exceptions.InvalidRequestException;
import org.springframework.security.oauth2.common.exceptions.InvalidScopeException;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.common.exceptions.OAuth2ExceptionDeserializer;
import org.springframework.security.oauth2.common.exceptions.OAuth2ExceptionSerializer;
import org.springframework.security.oauth2.common.exceptions.RedirectMismatchException;
import org.springframework.security.oauth2.common.exceptions.UnauthorizedClientException;
import org.springframework.security.oauth2.common.exceptions.UnsupportedGrantTypeException;
import org.springframework.security.oauth2.common.exceptions.UnsupportedResponseTypeException;
import org.springframework.security.oauth2.common.exceptions.UserDeniedAuthorizationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JsonSerialize(using=OAuth2ExceptionSerializer.class)
@JsonDeserialize(using=OAuth2ExceptionDeserializer.class)
public class OAuth2Exception
extends AuthenticationException {
    public static final String ERROR = "error";
    public static final String DESCRIPTION = "error_description";
    public static final String URI = "error_uri";
    public static final String INVALID_REQUEST = "invalid_request";
    public static final String INVALID_CLIENT = "invalid_client";
    public static final String INVALID_GRANT = "invalid_grant";
    public static final String UNAUTHORIZED_CLIENT = "unauthorized_client";
    public static final String UNSUPPORTED_GRANT_TYPE = "unsupported_grant_type";
    public static final String INVALID_SCOPE = "invalid_scope";
    public static final String INVALID_TOKEN = "invalid_token";
    public static final String REDIRECT_URI_MISMATCH = "redirect_uri_mismatch";
    public static final String UNSUPPORTED_RESPONSE_TYPE = "unsupported_response_type";
    public static final String ACCESS_DENIED = "access_denied";
    private Map<String, String> additionalInformation = null;

    public OAuth2Exception(String msg, Throwable t) {
        super(msg, t);
    }

    public OAuth2Exception(String msg) {
        super(msg);
    }

    public String getOAuth2ErrorCode() {
        return INVALID_REQUEST;
    }

    public int getHttpErrorCode() {
        return 400;
    }

    public Map<String, String> getAdditionalInformation() {
        return this.additionalInformation;
    }

    public void addAdditionalInformation(String key, String value) {
        if (this.additionalInformation == null) {
            this.additionalInformation = new TreeMap<String, String>();
        }
        this.additionalInformation.put(key, value);
    }

    public static OAuth2Exception create(String errorCode, String errorMessage) {
        if (errorMessage == null) {
            String string = errorMessage = errorCode == null ? "OAuth Error" : errorCode;
        }
        if (INVALID_CLIENT.equals(errorCode)) {
            return new InvalidClientException(errorMessage);
        }
        if (UNAUTHORIZED_CLIENT.equals(errorCode)) {
            return new UnauthorizedClientException(errorMessage);
        }
        if (INVALID_GRANT.equals(errorCode)) {
            return new InvalidGrantException(errorMessage);
        }
        if (INVALID_SCOPE.equals(errorCode)) {
            return new InvalidScopeException(errorMessage);
        }
        if (INVALID_TOKEN.equals(errorCode)) {
            return new InvalidTokenException(errorMessage);
        }
        if (INVALID_REQUEST.equals(errorCode)) {
            return new InvalidRequestException(errorMessage);
        }
        if (REDIRECT_URI_MISMATCH.equals(errorCode)) {
            return new RedirectMismatchException(errorMessage);
        }
        if (UNSUPPORTED_GRANT_TYPE.equals(errorCode)) {
            return new UnsupportedGrantTypeException(errorMessage);
        }
        if (UNSUPPORTED_RESPONSE_TYPE.equals(errorCode)) {
            return new UnsupportedResponseTypeException(errorMessage);
        }
        if (ACCESS_DENIED.equals(errorCode)) {
            return new UserDeniedAuthorizationException(errorMessage);
        }
        return new OAuth2Exception(errorMessage);
    }

    public static OAuth2Exception valueOf(Map<String, String> errorParams) {
        String errorCode = errorParams.get(ERROR);
        String errorMessage = errorParams.containsKey(DESCRIPTION) ? errorParams.get(DESCRIPTION) : null;
        OAuth2Exception ex = OAuth2Exception.create(errorCode, errorMessage);
        Set<Map.Entry<String, String>> entries = errorParams.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String key = entry.getKey();
            if (ERROR.equals(key) || DESCRIPTION.equals(key)) continue;
            ex.addAdditionalInformation(key, entry.getValue());
        }
        return ex;
    }

    public String toString() {
        return this.getSummary();
    }

    public String getSummary() {
        Map<String, String> additionalParams;
        String errorMessage;
        StringBuilder builder = new StringBuilder();
        String delim = "";
        String error = this.getOAuth2ErrorCode();
        if (error != null) {
            builder.append(delim).append("error=\"").append(error).append("\"");
            delim = ", ";
        }
        if ((errorMessage = this.getMessage()) != null) {
            builder.append(delim).append("error_description=\"").append(errorMessage).append("\"");
            delim = ", ";
        }
        if ((additionalParams = this.getAdditionalInformation()) != null) {
            for (Map.Entry<String, String> param : additionalParams.entrySet()) {
                builder.append(delim).append(param.getKey()).append("=\"").append(param.getValue()).append("\"");
                delim = ", ";
            }
        }
        return builder.toString();
    }
}

