/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.token.grant.implicit;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.oauth2.client.UserRedirectRequiredException;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.OAuth2AccessTokenSupport;
import org.springframework.security.oauth2.client.token.grant.implicit.ImplicitResourceDetails;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResponseExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplicitAccessTokenProvider
extends OAuth2AccessTokenSupport
implements AccessTokenProvider {
    @Override
    public boolean supportsResource(OAuth2ProtectedResourceDetails resource) {
        return resource instanceof ImplicitResourceDetails && "implicit".equals(resource.getGrantType());
    }

    @Override
    public boolean supportsRefresh(OAuth2ProtectedResourceDetails resource) {
        return false;
    }

    @Override
    public OAuth2AccessToken refreshAccessToken(OAuth2ProtectedResourceDetails resource, OAuth2RefreshToken refreshToken, AccessTokenRequest request) throws UserRedirectRequiredException {
        return null;
    }

    @Override
    public OAuth2AccessToken obtainAccessToken(OAuth2ProtectedResourceDetails details, AccessTokenRequest request) throws UserRedirectRequiredException, AccessDeniedException {
        ImplicitResourceDetails resource = (ImplicitResourceDetails)details;
        return this.retrieveToken(this.getParametersForTokenRequest(resource, request), resource);
    }

    @Override
    protected ResponseExtractor<OAuth2AccessToken> getResponseExtractor() {
        return new ImplicitResponseExtractor();
    }

    private MultiValueMap<String, String> getParametersForTokenRequest(ImplicitResourceDetails resource, AccessTokenRequest request) {
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        form.add((Object)"response_type", (Object)"token");
        form.add((Object)"client_id", (Object)resource.getClientId());
        if (resource.isScoped()) {
            StringBuilder builder = new StringBuilder();
            List<String> scope = resource.getScope();
            if (scope != null) {
                Iterator<String> scopeIt = scope.iterator();
                while (scopeIt.hasNext()) {
                    builder.append(scopeIt.next());
                    if (!scopeIt.hasNext()) continue;
                    builder.append(' ');
                }
            }
            form.add((Object)"scope", (Object)builder.toString());
        }
        for (String key : request.keySet()) {
            form.put((Object)key, request.get(key));
        }
        if (request.getCurrentUri() == null && resource.getPreEstablishedRedirectUri() != null) {
            form.set((Object)"redirect_uri", (Object)resource.getPreEstablishedRedirectUri());
        }
        return form;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ImplicitResponseExtractor
    implements ResponseExtractor<OAuth2AccessToken> {
        private ImplicitResponseExtractor() {
        }

        public OAuth2AccessToken extractData(ClientHttpResponse response) throws IOException {
            String fragment = response.getHeaders().getLocation().getFragment();
            HashMap<String, String> map = new HashMap<String, String>();
            Properties properties = StringUtils.splitArrayElementsIntoProperties((String[])StringUtils.delimitedListToStringArray((String)fragment, (String)"&"), (String)"=");
            for (Object key : properties.keySet()) {
                map.put(key.toString(), properties.get(key).toString());
            }
            return OAuth2AccessToken.valueOf(map);
        }
    }
}

