/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.token.grant.code;

import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.oauth2.client.UserRedirectRequiredException;
import org.springframework.security.oauth2.client.filter.state.DefaultStateKeyGenerator;
import org.springframework.security.oauth2.client.filter.state.StateKeyGenerator;
import org.springframework.security.oauth2.client.resource.OAuth2AccessDeniedException;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.OAuth2AccessTokenSupport;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationCodeAccessTokenProvider
extends OAuth2AccessTokenSupport
implements AccessTokenProvider {
    private StateKeyGenerator stateKeyGenerator = new DefaultStateKeyGenerator();

    public void setStateKeyGenerator(StateKeyGenerator stateKeyGenerator) {
        this.stateKeyGenerator = stateKeyGenerator;
    }

    @Override
    public boolean supportsResource(OAuth2ProtectedResourceDetails resource) {
        return resource instanceof AuthorizationCodeResourceDetails && "authorization_code".equals(resource.getGrantType());
    }

    @Override
    public boolean supportsRefresh(OAuth2ProtectedResourceDetails resource) {
        return this.supportsResource(resource);
    }

    @Override
    public OAuth2AccessToken obtainAccessToken(OAuth2ProtectedResourceDetails details, AccessTokenRequest request) throws UserRedirectRequiredException, AccessDeniedException {
        AuthorizationCodeResourceDetails resource = (AuthorizationCodeResourceDetails)details;
        if (request.getAuthorizationCode() == null) {
            throw this.getRedirectForAuthorization(resource, request);
        }
        return this.retrieveToken(this.getParametersForTokenRequest(resource, request), resource);
    }

    @Override
    public OAuth2AccessToken refreshAccessToken(OAuth2ProtectedResourceDetails resource, OAuth2RefreshToken refreshToken, AccessTokenRequest request) throws UserRedirectRequiredException {
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        form.add((Object)"grant_type", (Object)"refresh_token");
        form.add((Object)"refresh_token", (Object)refreshToken.getValue());
        try {
            return this.retrieveToken((MultiValueMap<String, String>)form, resource);
        }
        catch (OAuth2AccessDeniedException e) {
            throw this.getRedirectForAuthorization((AuthorizationCodeResourceDetails)resource, request);
        }
    }

    private MultiValueMap<String, String> getParametersForTokenRequest(AuthorizationCodeResourceDetails resource, AccessTokenRequest request) {
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        form.add((Object)"grant_type", (Object)"authorization_code");
        form.add((Object)"code", (Object)request.getAuthorizationCode());
        String redirectUri = resource.getPreEstablishedRedirectUri();
        if (redirectUri == null && request.getPreservedState() != null) {
            redirectUri = String.valueOf(request.getPreservedState());
        }
        if (request.getStateKey() != null) {
            form.add((Object)"state", (Object)request.getStateKey());
        }
        if (redirectUri != null) {
            form.add((Object)"redirect_uri", (Object)redirectUri);
        }
        return form;
    }

    private UserRedirectRequiredException getRedirectForAuthorization(AuthorizationCodeResourceDetails resource, AccessTokenRequest request) {
        TreeMap<String, String> requestParameters = new TreeMap<String, String>();
        requestParameters.put("response_type", "code");
        requestParameters.put("client_id", resource.getClientId());
        String redirectUri = resource.getPreEstablishedRedirectUri();
        String userRedirectUri = request.getCurrentUri();
        if (redirectUri == null) {
            redirectUri = userRedirectUri;
            if (redirectUri == null) {
                throw new IllegalStateException("No redirect URI has been established for the current request.");
            }
            requestParameters.put("redirect_uri", redirectUri);
        } else {
            redirectUri = null;
        }
        if (resource.isScoped()) {
            StringBuilder builder = new StringBuilder();
            List<String> scope = resource.getScope();
            if (scope != null) {
                Iterator<String> scopeIt = scope.iterator();
                while (scopeIt.hasNext()) {
                    builder.append(scopeIt.next());
                    if (!scopeIt.hasNext()) continue;
                    builder.append(' ');
                }
            }
            requestParameters.put("scope", builder.toString());
        }
        UserRedirectRequiredException redirectException = new UserRedirectRequiredException(resource.getUserAuthorizationUri(), requestParameters);
        String stateKey = this.stateKeyGenerator.generateKey(resource);
        if (stateKey != null) {
            redirectException.setStateKey(stateKey);
            if (userRedirectUri != null) {
                redirectException.setStateToPreserve(userRedirectUri);
            }
        }
        return redirectException;
    }
}

