/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.http;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.security.oauth2.client.context.OAuth2ClientContext;
import org.springframework.security.oauth2.client.context.OAuth2ClientContextHolder;
import org.springframework.security.oauth2.client.http.AccessTokenRequiredException;
import org.springframework.security.oauth2.client.resource.OAuth2AccessDeniedException;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.common.AuthenticationScheme;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.util.StringUtils;

public class OAuth2ClientHttpRequestFactory
implements ClientHttpRequestFactory {
    private final ClientHttpRequestFactory delegate;
    private final OAuth2ProtectedResourceDetails resource;

    public OAuth2ClientHttpRequestFactory(ClientHttpRequestFactory delegate, OAuth2ProtectedResourceDetails resource) {
        this.delegate = delegate;
        this.resource = resource;
        if (delegate == null) {
            throw new IllegalArgumentException("A delegate must be supplied for an OAuth2ClientHttpRequestFactory.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("A resource must be supplied for an OAuth2ClientHttpRequestFactory.");
        }
    }

    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        OAuth2ClientContext context = OAuth2ClientContextHolder.getContext();
        if (context == null) {
            throw new IllegalStateException("No OAuth 2 security context has been established. Unable to access resource '" + this.resource.getId() + "'.");
        }
        OAuth2AccessToken accessToken = context.getAccessToken(this.resource);
        if (accessToken == null) {
            throw new AccessTokenRequiredException("No OAuth 2 security context has been established. Unable to access resource '" + this.resource.getId() + "'.", this.resource);
        }
        if (accessToken.isExpired()) {
            throw new AccessTokenRequiredException("OAuth 2 token is expired. Unable to access resource '" + this.resource.getId() + "'.", this.resource);
        }
        String tokenType = accessToken.getTokenType();
        if (!StringUtils.hasText((String)tokenType)) {
            tokenType = OAuth2AccessToken.BEARER_TYPE;
        }
        if (OAuth2AccessToken.BEARER_TYPE.equalsIgnoreCase(tokenType) || OAuth2AccessToken.OAUTH2_TYPE.equalsIgnoreCase(tokenType)) {
            AuthenticationScheme bearerTokenMethod = this.resource.getAuthenticationScheme();
            if (AuthenticationScheme.query.equals((Object)bearerTokenMethod)) {
                uri = this.appendQueryParameter(uri, accessToken);
            }
            ClientHttpRequest req = this.delegate.createRequest(uri, httpMethod);
            if (AuthenticationScheme.header.equals((Object)bearerTokenMethod)) {
                req.getHeaders().add("Authorization", String.format("%s %s", OAuth2AccessToken.BEARER_TYPE, accessToken.getValue()));
            }
            return req;
        }
        throw new OAuth2AccessDeniedException("Unsupported access token type: " + tokenType);
    }

    protected URI appendQueryParameter(URI uri, OAuth2AccessToken accessToken) {
        try {
            String query = uri.getQuery();
            String queryFragment = this.resource.getTokenName() + "=" + URLEncoder.encode(accessToken.getValue(), "UTF-8");
            query = query == null ? queryFragment : query + "&" + queryFragment;
            URI update = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), null, null);
            StringBuffer sb = new StringBuffer(update.toString());
            sb.append("?");
            sb.append(query);
            if (uri.getFragment() != null) {
                sb.append("#");
                sb.append(uri.getFragment());
            }
            return new URI(sb.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Could not parse URI", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Could not encode URI", e);
        }
    }
}

