/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.filter.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.security.oauth2.client.filter.cache.AccessTokenCache;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.common.OAuth2AccessToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpSessionAccessTokenCache
implements AccessTokenCache {
    private static final String REMEMBERED_TOKENS_KEY = HttpSessionAccessTokenCache.class.getName() + "#REMEMBERED_TOKENS";
    private Map<String, OAuth2AccessToken> clientTokens = new HashMap<String, OAuth2AccessToken>();
    private boolean allowSessionCreation = true;

    public void setAllowSessionCreation(boolean allowSessionCreation) {
        this.allowSessionCreation = allowSessionCreation;
    }

    @Override
    public Map<String, OAuth2AccessToken> loadRememberedTokens(HttpServletRequest request, HttpServletResponse response) {
        Map rememberedTokens;
        HttpSession session = request.getSession(this.allowSessionCreation);
        HashMap<String, OAuth2AccessToken> tokens = new HashMap<String, OAuth2AccessToken>(this.clientTokens);
        if (session != null && (rememberedTokens = (Map)session.getAttribute(REMEMBERED_TOKENS_KEY)) != null) {
            tokens.putAll(rememberedTokens);
        }
        return tokens;
    }

    @Override
    public void rememberTokens(Map<OAuth2ProtectedResourceDetails, OAuth2AccessToken> map, HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(this.allowSessionCreation);
        if (session != null) {
            HashMap<String, OAuth2AccessToken> tokens = new HashMap<String, OAuth2AccessToken>();
            Map rememberedTokens = (Map)session.getAttribute(REMEMBERED_TOKENS_KEY);
            if (rememberedTokens != null) {
                tokens.putAll(rememberedTokens);
            }
            for (OAuth2ProtectedResourceDetails resource : map.keySet()) {
                if (resource.isClientOnly()) continue;
                tokens.put(resource.getId(), map.get(resource));
            }
            session.setAttribute(REMEMBERED_TOKENS_KEY, Collections.unmodifiableMap(tokens));
        }
        for (OAuth2ProtectedResourceDetails resource : map.keySet()) {
            if (!resource.isClientOnly()) continue;
            this.clientTokens.put(resource.getId(), map.get(resource));
        }
    }
}

