/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.context;

import org.springframework.security.oauth2.client.context.OAuth2ClientContext;

public class OAuth2ClientContextHolder {
    private static final ThreadLocal<OAuth2ClientContext> CURRENT_CONTEXT = new ThreadLocal();

    public static OAuth2ClientContext getContext() {
        return CURRENT_CONTEXT.get();
    }

    public static void setContext(OAuth2ClientContext context) {
        if (context != null) {
            CURRENT_CONTEXT.set(context);
        } else {
            OAuth2ClientContextHolder.clearContext();
        }
    }

    public static void clearContext() {
        CURRENT_CONTEXT.remove();
    }
}

