/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.common.OAuth2AccessToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuth2ClientContext {
    private final Map<String, OAuth2AccessToken> accessTokens;
    private final Map<String, OAuth2ProtectedResourceDetails> resources = new HashMap<String, OAuth2ProtectedResourceDetails>();

    public OAuth2ClientContext() {
        this(Collections.emptyMap());
    }

    public OAuth2ClientContext(Map<String, OAuth2AccessToken> accessTokens) {
        this.accessTokens = new ConcurrentHashMap<String, OAuth2AccessToken>(accessTokens);
    }

    public OAuth2AccessToken getAccessToken(OAuth2ProtectedResourceDetails resource) {
        return this.accessTokens.get(resource.getId());
    }

    public void removeAccessToken(OAuth2ProtectedResourceDetails resource) {
        this.accessTokens.remove(resource.getId());
        this.resources.remove(resource.getId());
    }

    public boolean containsResource(OAuth2ProtectedResourceDetails resource) {
        return this.accessTokens.containsKey(resource.getId());
    }

    public void addAccessToken(OAuth2ProtectedResourceDetails resource, OAuth2AccessToken accessToken) {
        this.accessTokens.put(resource.getId(), accessToken);
        this.resources.put(resource.getId(), resource);
    }

    public Map<OAuth2ProtectedResourceDetails, OAuth2AccessToken> getNewAccessTokens() {
        HashMap<OAuth2ProtectedResourceDetails, OAuth2AccessToken> result = new HashMap<OAuth2ProtectedResourceDetails, OAuth2AccessToken>();
        for (String id : this.resources.keySet()) {
            result.put(this.resources.get(id), this.accessTokens.get(id));
        }
        return result;
    }
}

