/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.provider.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth.common.OAuthConsumerParameter;
import org.springframework.security.oauth.common.OAuthException;
import org.springframework.security.oauth.common.signature.CoreOAuthSignatureMethodFactory;
import org.springframework.security.oauth.common.signature.OAuthSignatureMethod;
import org.springframework.security.oauth.common.signature.OAuthSignatureMethodFactory;
import org.springframework.security.oauth.common.signature.SignatureSecret;
import org.springframework.security.oauth.common.signature.UnsupportedSignatureMethodException;
import org.springframework.security.oauth.provider.ConsumerAuthentication;
import org.springframework.security.oauth.provider.ConsumerCredentials;
import org.springframework.security.oauth.provider.ConsumerDetails;
import org.springframework.security.oauth.provider.ConsumerDetailsService;
import org.springframework.security.oauth.provider.InvalidOAuthParametersException;
import org.springframework.security.oauth.provider.OAuthAuthenticationDetails;
import org.springframework.security.oauth.provider.OAuthProcessingFilterEntryPoint;
import org.springframework.security.oauth.provider.OAuthProviderSupport;
import org.springframework.security.oauth.provider.OAuthVersionUnsupportedException;
import org.springframework.security.oauth.provider.filter.CoreOAuthProviderSupport;
import org.springframework.security.oauth.provider.nonce.ExpiringTimestampNonceServices;
import org.springframework.security.oauth.provider.nonce.OAuthNonceServices;
import org.springframework.security.oauth.provider.token.OAuthProviderToken;
import org.springframework.security.oauth.provider.token.OAuthProviderTokenServices;
import org.springframework.util.Assert;

public abstract class OAuthProviderProcessingFilter
implements Filter,
InitializingBean,
MessageSourceAware {
    public static final String OAUTH_PROCESSING_HANDLED = "org.springframework.security.oauth.provider.OAuthProviderProcessingFilter#SKIP_PROCESSING";
    private final Log log = LogFactory.getLog(this.getClass());
    private final List<String> allowedMethods = new ArrayList<String>(Arrays.asList("GET", "POST"));
    private OAuthProcessingFilterEntryPoint authenticationEntryPoint = new OAuthProcessingFilterEntryPoint();
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private String filterProcessesUrl = "/oauth_filter";
    private OAuthProviderSupport providerSupport = new CoreOAuthProviderSupport();
    private OAuthSignatureMethodFactory signatureMethodFactory = new CoreOAuthSignatureMethodFactory();
    private OAuthNonceServices nonceServices = new ExpiringTimestampNonceServices();
    private boolean ignoreMissingCredentials = false;
    private OAuthProviderTokenServices tokenServices;
    private ConsumerDetailsService consumerDetailsService;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.consumerDetailsService, (String)"A consumer details service is required.");
        Assert.notNull((Object)this.tokenServices, (String)"Token services are required.");
    }

    public void init(FilterConfig ignored) throws ServletException {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (!this.skipProcessing(request)) {
            if (this.requiresAuthentication(request, response, chain)) {
                if (!this.allowMethod(request.getMethod().toUpperCase())) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Method " + request.getMethod() + " not supported."));
                    }
                    response.sendError(405);
                    return;
                }
                try {
                    Map<String, String> oauthParams = this.getProviderSupport().parseParameters(request);
                    if (this.parametersAreAdequate(oauthParams)) {
                        String consumerKey;
                        if (this.log.isDebugEnabled()) {
                            StringBuilder builder = new StringBuilder("OAuth parameters parsed: ");
                            for (String param : oauthParams.keySet()) {
                                builder.append(param).append('=').append(oauthParams.get(param)).append(' ');
                            }
                            this.log.debug((Object)builder.toString());
                        }
                        if ((consumerKey = oauthParams.get(OAuthConsumerParameter.oauth_consumer_key.toString())) == null) {
                            throw new InvalidOAuthParametersException(this.messages.getMessage("OAuthProcessingFilter.missingConsumerKey", "Missing consumer key."));
                        }
                        ConsumerDetails consumerDetails = this.getConsumerDetailsService().loadConsumerByConsumerKey(consumerKey);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Consumer details loaded for " + consumerKey + ": " + consumerDetails));
                        }
                        this.validateOAuthParams(consumerDetails, oauthParams);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"Parameters validated.");
                        }
                        String token = oauthParams.get(OAuthConsumerParameter.oauth_token.toString());
                        String signatureMethod = oauthParams.get(OAuthConsumerParameter.oauth_signature_method.toString());
                        String signature = oauthParams.get(OAuthConsumerParameter.oauth_signature.toString());
                        String signatureBaseString = this.getProviderSupport().getSignatureBaseString(request);
                        ConsumerCredentials credentials = new ConsumerCredentials(consumerKey, signature, signatureMethod, signatureBaseString, token);
                        ConsumerAuthentication authentication = new ConsumerAuthentication(consumerDetails, credentials, oauthParams);
                        authentication.setDetails(this.createDetails(request, consumerDetails));
                        Authentication previousAuthentication = SecurityContextHolder.getContext().getAuthentication();
                        try {
                            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
                            this.validateSignature(authentication);
                            authentication.setSignatureValidated(true);
                            request.setAttribute(OAUTH_PROCESSING_HANDLED, (Object)Boolean.TRUE);
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)"Signature validated.");
                            }
                            this.onValidSignature(request, response, chain);
                        }
                        finally {
                            this.resetPreviousAuthentication(previousAuthentication);
                        }
                    }
                    if (!this.isIgnoreInadequateCredentials()) {
                        throw new InvalidOAuthParametersException(this.messages.getMessage("OAuthProcessingFilter.missingCredentials", "Inadequate OAuth consumer credentials."));
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"Supplied OAuth parameters are inadequate. Ignoring.");
                    }
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                }
                catch (AuthenticationException ae) {
                    this.fail(request, response, ae);
                }
                catch (ServletException e) {
                    if (e.getRootCause() instanceof AuthenticationException) {
                        this.fail(request, response, (AuthenticationException)e.getRootCause());
                    }
                    throw e;
                }
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Request does not require authentication.  OAuth processing skipped.");
                }
                chain.doFilter(servletRequest, servletResponse);
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Processing explicitly skipped.");
            }
            chain.doFilter(servletRequest, servletResponse);
        }
    }

    protected boolean parametersAreAdequate(Map<String, String> oauthParams) {
        return oauthParams.containsKey(OAuthConsumerParameter.oauth_consumer_key.toString());
    }

    protected void resetPreviousAuthentication(Authentication previousAuthentication) {
        SecurityContextHolder.getContext().setAuthentication(previousAuthentication);
    }

    protected Object createDetails(HttpServletRequest request, ConsumerDetails consumerDetails) {
        return new OAuthAuthenticationDetails(request, consumerDetails);
    }

    protected boolean allowMethod(String method) {
        return this.allowedMethods.contains(method);
    }

    protected void validateSignature(ConsumerAuthentication authentication) throws AuthenticationException {
        OAuthSignatureMethod method;
        SignatureSecret secret = authentication.getConsumerDetails().getSignatureSecret();
        String token = authentication.getConsumerCredentials().getToken();
        OAuthProviderToken authToken = null;
        if (token != null && !"".equals(token)) {
            authToken = this.getTokenServices().getToken(token);
        }
        String signatureMethod = authentication.getConsumerCredentials().getSignatureMethod();
        try {
            method = this.getSignatureMethodFactory().getSignatureMethod(signatureMethod, secret, authToken != null ? authToken.getSecret() : null);
        }
        catch (UnsupportedSignatureMethodException e) {
            throw new OAuthException(e.getMessage(), e);
        }
        String signatureBaseString = authentication.getConsumerCredentials().getSignatureBaseString();
        String signature = authentication.getConsumerCredentials().getSignature();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Verifying signature " + signature + " for signature base string " + signatureBaseString + " with method " + method.getName() + "."));
        }
        method.verify(signatureBaseString, signature);
    }

    protected abstract void onValidSignature(HttpServletRequest var1, HttpServletResponse var2, FilterChain var3) throws IOException, ServletException;

    protected void validateOAuthParams(ConsumerDetails consumerDetails, Map<String, String> oauthParams) throws InvalidOAuthParametersException {
        String version = oauthParams.get(OAuthConsumerParameter.oauth_version.toString());
        if (version != null && !"1.0".equals(version)) {
            throw new OAuthVersionUnsupportedException("Unsupported OAuth version: " + version);
        }
        String realm = oauthParams.get("realm");
        String string = realm = realm == null || "".equals(realm) ? null : realm;
        if (realm != null && !realm.equals(this.authenticationEntryPoint.getRealmName())) {
            throw new InvalidOAuthParametersException(this.messages.getMessage("OAuthProcessingFilter.incorrectRealm", new Object[]{realm, this.getAuthenticationEntryPoint().getRealmName()}, "Response realm name '{0}' does not match system realm name of '{1}'"));
        }
        String signatureMethod = oauthParams.get(OAuthConsumerParameter.oauth_signature_method.toString());
        if (signatureMethod == null) {
            throw new InvalidOAuthParametersException(this.messages.getMessage("OAuthProcessingFilter.missingSignatureMethod", "Missing signature method."));
        }
        String signature = oauthParams.get(OAuthConsumerParameter.oauth_signature.toString());
        if (signature == null) {
            throw new InvalidOAuthParametersException(this.messages.getMessage("OAuthProcessingFilter.missingSignature", "Missing signature."));
        }
        String timestamp = oauthParams.get(OAuthConsumerParameter.oauth_timestamp.toString());
        if (timestamp == null) {
            throw new InvalidOAuthParametersException(this.messages.getMessage("OAuthProcessingFilter.missingTimestamp", "Missing timestamp."));
        }
        String nonce = oauthParams.get(OAuthConsumerParameter.oauth_nonce.toString());
        if (nonce == null) {
            throw new InvalidOAuthParametersException(this.messages.getMessage("OAuthProcessingFilter.missingNonce", "Missing nonce."));
        }
        try {
            this.getNonceServices().validateNonce(consumerDetails, Long.parseLong(timestamp), nonce);
        }
        catch (NumberFormatException e) {
            throw new InvalidOAuthParametersException(this.messages.getMessage("OAuthProcessingFilter.invalidTimestamp", new Object[]{timestamp}, "Timestamp must be a positive integer. Invalid value: {0}"));
        }
        this.validateAdditionalParameters(consumerDetails, oauthParams);
    }

    protected void validateAdditionalParameters(ConsumerDetails consumerDetails, Map<String, String> oauthParams) {
    }

    protected void onNewTimestamp() throws AuthenticationException {
        throw new InvalidOAuthParametersException(this.messages.getMessage("OAuthProcessingFilter.timestampNotNew", "A new timestamp should not be used in a request for an access token."));
    }

    protected void fail(HttpServletRequest request, HttpServletResponse response, AuthenticationException failure) throws IOException, ServletException {
        SecurityContextHolder.getContext().setAuthentication(null);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)failure);
        }
        this.authenticationEntryPoint.commence(request, response, failure);
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) {
        String uri = request.getRequestURI();
        int pathParamIndex = uri.indexOf(59);
        if (pathParamIndex > 0) {
            uri = uri.substring(0, pathParamIndex);
        }
        if ("".equals(request.getContextPath())) {
            return uri.endsWith(this.filterProcessesUrl);
        }
        boolean match = uri.endsWith(request.getContextPath() + this.filterProcessesUrl);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(uri + (match ? " matches " : " does not match ") + this.filterProcessesUrl));
        }
        return match;
    }

    protected boolean skipProcessing(HttpServletRequest request) {
        return request.getAttribute(OAUTH_PROCESSING_HANDLED) != null && Boolean.TRUE.equals(request.getAttribute(OAUTH_PROCESSING_HANDLED));
    }

    public OAuthProcessingFilterEntryPoint getAuthenticationEntryPoint() {
        return this.authenticationEntryPoint;
    }

    @Autowired(required=false)
    public void setAuthenticationEntryPoint(OAuthProcessingFilterEntryPoint authenticationEntryPoint) {
        this.authenticationEntryPoint = authenticationEntryPoint;
    }

    public ConsumerDetailsService getConsumerDetailsService() {
        return this.consumerDetailsService;
    }

    @Autowired
    public void setConsumerDetailsService(ConsumerDetailsService consumerDetailsService) {
        this.consumerDetailsService = consumerDetailsService;
    }

    public OAuthNonceServices getNonceServices() {
        return this.nonceServices;
    }

    @Autowired(required=false)
    public void setNonceServices(OAuthNonceServices nonceServices) {
        this.nonceServices = nonceServices;
    }

    public OAuthProviderTokenServices getTokenServices() {
        return this.tokenServices;
    }

    @Autowired
    public void setTokenServices(OAuthProviderTokenServices tokenServices) {
        this.tokenServices = tokenServices;
    }

    public String getFilterProcessesUrl() {
        return this.filterProcessesUrl;
    }

    public void setFilterProcessesUrl(String filterProcessesUrl) {
        this.filterProcessesUrl = filterProcessesUrl;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public OAuthProviderSupport getProviderSupport() {
        return this.providerSupport;
    }

    @Autowired(required=false)
    public void setProviderSupport(OAuthProviderSupport providerSupport) {
        this.providerSupport = providerSupport;
    }

    public OAuthSignatureMethodFactory getSignatureMethodFactory() {
        return this.signatureMethodFactory;
    }

    @Autowired(required=false)
    public void setSignatureMethodFactory(OAuthSignatureMethodFactory signatureMethodFactory) {
        this.signatureMethodFactory = signatureMethodFactory;
    }

    public boolean isIgnoreInadequateCredentials() {
        return this.ignoreMissingCredentials;
    }

    public void setIgnoreMissingCredentials(boolean ignoreMissingCredentials) {
        this.ignoreMissingCredentials = ignoreMissingCredentials;
    }

    public void setAllowedMethods(List<String> allowedMethods) {
        this.allowedMethods.clear();
        if (allowedMethods != null) {
            for (String allowedMethod : allowedMethods) {
                this.allowedMethods.add(allowedMethod.toUpperCase());
            }
        }
    }
}

