/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.provider.attributes;

import java.util.Collection;
import java.util.List;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth.provider.OAuthAuthenticationDetails;
import org.springframework.security.oauth.provider.attributes.ConsumerSecurityConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerSecurityVoter
implements AccessDecisionVoter<Object> {
    public boolean supports(ConfigAttribute attribute) {
        return attribute instanceof ConsumerSecurityConfig;
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }

    public int vote(Authentication authentication, Object object, Collection<ConfigAttribute> configAttributes) {
        int result = 0;
        if (authentication.getDetails() instanceof OAuthAuthenticationDetails) {
            OAuthAuthenticationDetails details = (OAuthAuthenticationDetails)((Object)authentication.getDetails());
            for (ConfigAttribute configAttribute : configAttributes) {
                List<GrantedAuthority> authorities;
                ConfigAttribute attribute = configAttribute;
                if (ConsumerSecurityConfig.PERMIT_ALL_ATTRIBUTE.equals(attribute)) {
                    return 1;
                }
                if (ConsumerSecurityConfig.DENY_ALL_ATTRIBUTE.equals(attribute)) {
                    return -1;
                }
                if (!this.supports(attribute)) continue;
                ConsumerSecurityConfig config = (ConsumerSecurityConfig)attribute;
                if (config.getSecurityType() == ConsumerSecurityConfig.ConsumerSecurityType.CONSUMER_KEY && config.getAttribute().equals(details.getConsumerDetails().getConsumerKey())) {
                    return 1;
                }
                if (config.getSecurityType() != ConsumerSecurityConfig.ConsumerSecurityType.CONSUMER_ROLE || (authorities = details.getConsumerDetails().getAuthorities()) == null) continue;
                for (GrantedAuthority authority : authorities) {
                    if (!authority.getAuthority().equals(config.getAttribute())) continue;
                    return 1;
                }
            }
        }
        return result;
    }
}

