/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.verification;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth.provider.DefaultRedirectStrategy;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.common.exceptions.UnapprovedClientAuthenticationException;
import org.springframework.security.oauth2.common.exceptions.UnsupportedResponseTypeException;
import org.springframework.security.oauth2.common.exceptions.UserDeniedVerificationException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.verification.ClientAuthenticationCache;
import org.springframework.security.oauth2.provider.verification.DefaultClientAuthenticationCache;
import org.springframework.security.oauth2.provider.verification.DefaultRedirectResolver;
import org.springframework.security.oauth2.provider.verification.RedirectResolver;
import org.springframework.security.oauth2.provider.verification.UserApprovalHandler;
import org.springframework.security.oauth2.provider.verification.VerificationCodeAuthenticationToken;
import org.springframework.security.oauth2.provider.verification.VerificationCodeServices;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.util.Assert;

public class VerificationCodeFilter
extends AbstractAuthenticationProcessingFilter {
    private static final String VERIFICATION_CODE_ATTRIBUTE = VerificationCodeFilter.class.getName() + "#CODE";
    private static final String VERIFICATION_TOKEN_ATTRIBUTE = VerificationCodeFilter.class.getName() + "#TOKEN";
    public static final String DEFAULT_PROCESSING_URL = "/oauth/user/authorize";
    private ClientDetailsService clientDetailsService;
    private VerificationCodeServices verificationServices;
    private ClientAuthenticationCache authenticationCache = new DefaultClientAuthenticationCache();
    private RedirectResolver redirectResolver = new DefaultRedirectResolver();
    private RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
    private boolean customFailureHandling = false;
    private UserApprovalHandler userApprovalHandler;
    private AuthenticationFailureHandler unapprovedAuthenticationHandler;

    public VerificationCodeFilter() {
        super(DEFAULT_PROCESSING_URL);
        this.setAuthenticationManager((AuthenticationManager)new ProviderManager());
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.clientDetailsService, (String)"A client details service must be supplied.");
        Assert.notNull((Object)this.verificationServices, (String)"Verification code services must be supplied.");
        Assert.notNull((Object)this.redirectResolver, (String)"A redirect resolver must be supplied.");
        Assert.notNull((Object)this.authenticationCache, (String)"An authentication cache must be supplied.");
        Assert.notNull((Object)this.redirectStrategy, (String)"A redirect strategy must be supplied.");
        Assert.notNull((Object)this.userApprovalHandler, (String)"A user approval handler must be supplied.");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String responseType = request.getParameter("response_type");
        if ("code".equals(responseType)) {
            String clientId = request.getParameter("client_id");
            String redirectUri = request.getParameter("redirect_uri");
            TreeSet<String> scope = new TreeSet<String>();
            String scopeValue = request.getParameter("scope");
            if (scopeValue != null) {
                String[] tokens = scopeValue.split("[\\s+,]");
                scope.addAll(Arrays.asList(tokens));
            }
            String state = request.getParameter("state");
            VerificationCodeAuthenticationToken verificationAuthenticationToken = new VerificationCodeAuthenticationToken(clientId, scope, state, redirectUri);
            if (clientId == null) {
                request.setAttribute(VERIFICATION_TOKEN_ATTRIBUTE, (Object)verificationAuthenticationToken);
                this.unsuccessfulAuthentication(request, response, new InvalidClientException("A client_id parameter must be supplied."));
                return;
            }
            this.getAuthenticationCache().saveAuthentication(verificationAuthenticationToken, request, response);
        } else {
            if ("token".equals(responseType)) {
                throw new UnsupportedResponseTypeException("Unsupported response type: token.");
            }
            if ("code_and_token".equals(responseType)) {
                throw new UnsupportedResponseTypeException("Unsupported response type: code_and_token.");
            }
        }
        super.doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException, ServletException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (!authentication.isAuthenticated()) {
            throw new InsufficientAuthenticationException("User must be authenticated before authorizing an access token.");
        }
        VerificationCodeAuthenticationToken saved = this.getAuthenticationCache().getAuthentication(request, response);
        if (saved == null) {
            throw new InsufficientAuthenticationException("No client authentication request has been issued.");
        }
        request.setAttribute(VERIFICATION_TOKEN_ATTRIBUTE, (Object)saved);
        try {
            if (saved.isDenied()) {
                throw new UserDeniedVerificationException("User denied authentication.");
            }
            if (!this.getUserApprovalHandler().isApproved(saved)) {
                throw new UnapprovedClientAuthenticationException("The client authentication hasn't been approved by the current user.");
            }
            String clientId = saved.getClientId();
            if (clientId == null) {
                throw new InvalidClientException("Invalid authentication request (no client id).");
            }
            ClientDetails client = this.getClientDetailsService().loadClientByClientId(clientId);
            String requestedRedirect = saved.getRequestedRedirect();
            String redirectUri = this.getRedirectResolver().resolveRedirect(requestedRedirect, client);
            if (redirectUri == null) {
                throw new OAuth2Exception("A redirect_uri must be supplied.");
            }
            this.getAuthenticationCache().removeAuthentication(request, response);
            OAuth2Authentication<VerificationCodeAuthenticationToken, Authentication> combinedAuth = new OAuth2Authentication<VerificationCodeAuthenticationToken, Authentication>(saved, authentication);
            String code = this.getVerificationServices().createVerificationCode(combinedAuth);
            request.setAttribute(VERIFICATION_CODE_ATTRIBUTE, (Object)code);
            return combinedAuth;
        }
        catch (OAuth2Exception e) {
            if (saved.getState() != null) {
                e.addAdditionalInformation("state", saved.getState());
            }
            throw e;
        }
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) throws IOException, ServletException {
        OAuth2Authentication authentication = (OAuth2Authentication)authResult;
        String verificationCode = (String)request.getAttribute(VERIFICATION_CODE_ATTRIBUTE);
        if (verificationCode == null) {
            throw new IllegalStateException("No verification code found in the current request scope.");
        }
        VerificationCodeAuthenticationToken clientAuth = (VerificationCodeAuthenticationToken)((Object)authentication.getClientAuthentication());
        String requestedRedirect = clientAuth.getRequestedRedirect();
        String state = clientAuth.getState();
        StringBuilder url = new StringBuilder(requestedRedirect);
        if (requestedRedirect.indexOf(63) < 0) {
            url.append('?');
        } else {
            url.append('&');
        }
        url.append("code=").append(verificationCode);
        if (state != null) {
            url.append("&state=").append(state);
        }
        this.getRedirectStrategy().sendRedirect(request, response, url.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException, ServletException {
        if (this.customFailureHandling) {
            super.unsuccessfulAuthentication(request, response, failed);
            return;
        } else if (failed instanceof UnapprovedClientAuthenticationException) {
            if (this.unapprovedAuthenticationHandler == null) throw new AccessDeniedException("User failed to approve client authentication.");
            this.unapprovedAuthenticationHandler.onAuthenticationFailure(request, response, failed);
            return;
        } else {
            if (!(failed instanceof OAuth2Exception)) throw failed;
            OAuth2Exception failure = (OAuth2Exception)failed;
            VerificationCodeAuthenticationToken token = (VerificationCodeAuthenticationToken)((Object)request.getAttribute(VERIFICATION_TOKEN_ATTRIBUTE));
            if (token == null || token.getRequestedRedirect() == null) {
                throw new UnapprovedClientAuthenticationException("Verification failure, and no redirect URI.", (Throwable)failed);
            }
            String redirectUri = token.getRequestedRedirect();
            StringBuilder url = new StringBuilder(redirectUri);
            if (redirectUri.indexOf(63) < 0) {
                url.append('?');
            } else {
                url.append('&');
            }
            url.append("error=").append(failure.getOAuth2ErrorCode());
            url.append("&error_description=").append(failure.getMessage());
            if (failure.getAdditionalInformation() != null) {
                for (Map.Entry<String, String> additionalInfo : failure.getAdditionalInformation().entrySet()) {
                    url.append('&').append(additionalInfo.getKey()).append('=').append(additionalInfo.getValue());
                }
            }
            this.getRedirectStrategy().sendRedirect(request, response, url.toString());
        }
    }

    public ClientDetailsService getClientDetailsService() {
        return this.clientDetailsService;
    }

    @Autowired
    public void setClientDetailsService(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }

    public VerificationCodeServices getVerificationServices() {
        return this.verificationServices;
    }

    @Autowired
    public void setVerificationServices(VerificationCodeServices verificationServices) {
        this.verificationServices = verificationServices;
    }

    public RedirectResolver getRedirectResolver() {
        return this.redirectResolver;
    }

    public void setRedirectResolver(RedirectResolver redirectResolver) {
        this.redirectResolver = redirectResolver;
    }

    public ClientAuthenticationCache getAuthenticationCache() {
        return this.authenticationCache;
    }

    public void setAuthenticationCache(ClientAuthenticationCache authenticationCache) {
        this.authenticationCache = authenticationCache;
    }

    public RedirectStrategy getRedirectStrategy() {
        return this.redirectStrategy;
    }

    public void setRedirectStrategy(RedirectStrategy redirectStrategy) {
        this.redirectStrategy = redirectStrategy;
    }

    public void setAuthenticationFailureHandler(AuthenticationFailureHandler failureHandler) {
        super.setAuthenticationFailureHandler(failureHandler);
        this.customFailureHandling = true;
    }

    public UserApprovalHandler getUserApprovalHandler() {
        return this.userApprovalHandler;
    }

    public void setUserApprovalHandler(UserApprovalHandler userApprovalHandler) {
        this.userApprovalHandler = userApprovalHandler;
    }

    public AuthenticationFailureHandler getUnapprovedAuthenticationHandler() {
        return this.unapprovedAuthenticationHandler;
    }

    public void setUnapprovedAuthenticationHandler(AuthenticationFailureHandler unapprovedAuthenticationHandler) {
        this.unapprovedAuthenticationHandler = unapprovedAuthenticationHandler;
    }
}

