/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.verification;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.oauth2.provider.verification.ClientAuthenticationCache;
import org.springframework.security.oauth2.provider.verification.VerificationCodeAuthenticationToken;

public class DefaultClientAuthenticationCache
implements ClientAuthenticationCache {
    public static final String SAVED_AUTH_KEY = "org.springframework.security.oauth2.provider.webserver.DefaultClientAuthenticationCache#SAVED_AUTH";
    protected final Log logger = LogFactory.getLog(this.getClass());

    public void saveAuthentication(VerificationCodeAuthenticationToken auth, HttpServletRequest request, HttpServletResponse response) {
        if (request.getSession(false) != null) {
            request.getSession().setAttribute(SAVED_AUTH_KEY, (Object)auth);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Client authentication added to the session: " + (Object)((Object)auth)));
            }
        } else {
            this.logger.warn((Object)"Unable to save client authentication because the request doesn't have a session!");
        }
    }

    public void updateAuthentication(VerificationCodeAuthenticationToken auth, HttpServletRequest request, HttpServletResponse response) {
        this.saveAuthentication(auth, request, response);
    }

    public VerificationCodeAuthenticationToken getAuthentication(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            return (VerificationCodeAuthenticationToken)((Object)session.getAttribute(SAVED_AUTH_KEY));
        }
        return null;
    }

    public void removeAuthentication(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            this.logger.debug((Object)"Removing client authentication from session if present");
            session.removeAttribute(SAVED_AUTH_KEY);
        }
    }
}

