/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.common;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.security.oauth2.common.OAuth2SerializationService;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;
import org.springframework.security.oauth2.common.exceptions.InvalidScopeException;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.common.exceptions.RedirectMismatchException;
import org.springframework.security.oauth2.common.exceptions.SerializationException;
import org.springframework.security.oauth2.common.exceptions.UnauthorizedClientException;
import org.springframework.security.oauth2.common.exceptions.UnsupportedGrantTypeException;
import org.springframework.security.oauth2.common.exceptions.UnsupportedResponseTypeException;
import org.springframework.security.oauth2.common.exceptions.UserDeniedVerificationException;
import org.springframework.security.oauth2.common.json.JSONException;
import org.springframework.security.oauth2.common.json.JSONObject;
import org.springframework.security.oauth2.common.json.JSONTokener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOAuth2SerializationService
implements OAuth2SerializationService {
    @Override
    public String serialize(OAuth2AccessToken accessToken) {
        try {
            Set<String> scope;
            OAuth2RefreshToken refreshToken;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("access_token", accessToken.getValue());
            jsonObject.put("token_type", accessToken.getTokenType());
            Date expiration = accessToken.getExpiration();
            if (expiration != null) {
                jsonObject.put("expires_in", (expiration.getTime() - System.currentTimeMillis()) / 1000L);
            }
            if ((refreshToken = accessToken.getRefreshToken()) != null) {
                jsonObject.put("refresh_token", refreshToken.getValue());
            }
            if ((scope = accessToken.getScope()) != null && !scope.isEmpty()) {
                StringBuilder join = new StringBuilder();
                for (String sc : scope) {
                    join.append(sc).append(' ');
                }
                jsonObject.put("scope", join.toString().trim());
            }
            return jsonObject.toString(2);
        }
        catch (JSONException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public OAuth2AccessToken deserializeJsonAccessToken(InputStream serialization) {
        try {
            TreeMap<String, String> tokenParams = new TreeMap<String, String>();
            JSONObject object = new JSONObject(new JSONTokener(new InputStreamReader(serialization, "UTF-8")));
            Iterator keys = object.keys();
            if (keys != null) {
                while (keys.hasNext()) {
                    String key = String.valueOf(keys.next());
                    tokenParams.put(key, object.getString(key));
                }
            }
            return this.deserializeAccessToken(tokenParams);
        }
        catch (JSONException e) {
            throw new SerializationException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public OAuth2AccessToken deserializeAccessToken(Map<String, String> tokenParams) {
        OAuth2AccessToken token = new OAuth2AccessToken();
        token.setValue(tokenParams.get("access_token"));
        if (tokenParams.containsKey("expires_in")) {
            long expiration = 0L;
            try {
                expiration = Long.parseLong(tokenParams.get("expires_in"));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            token.setExpiration(new Date(expiration * 1000L));
        }
        if (tokenParams.containsKey("refresh_token")) {
            String refresh = tokenParams.get("refresh_token");
            OAuth2RefreshToken refreshToken = new OAuth2RefreshToken();
            refreshToken.setValue(refresh);
            token.setRefreshToken(refreshToken);
        }
        if (tokenParams.containsKey("scope")) {
            TreeSet<String> scope = new TreeSet<String>();
            StringTokenizer tokenizer = new StringTokenizer(tokenParams.get("scope"), " ,");
            while (tokenizer.hasMoreTokens()) {
                scope.add(tokenizer.nextToken());
            }
            token.setScope(scope);
        }
        if (tokenParams.containsKey("token_type")) {
            token.setTokenType(tokenParams.get("token_type"));
        }
        return token;
    }

    @Override
    public String serialize(OAuth2Exception exception) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("error", exception.getOAuth2ErrorCode());
            jsonObject.put("error_description", exception.getMessage());
            Map<String, String> additionalInfo = exception.getAdditionalInformation();
            if (additionalInfo != null) {
                for (Map.Entry<String, String> entry : additionalInfo.entrySet()) {
                    jsonObject.put(entry.getKey(), entry.getValue());
                }
            }
            return jsonObject.toString(2);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public OAuth2Exception deserializeJsonError(InputStream serialization) {
        try {
            TreeMap<String, String> errorResponse = new TreeMap<String, String>();
            JSONObject object = new JSONObject(new JSONTokener(new InputStreamReader(serialization, "UTF-8")));
            Iterator keys = object.keys();
            if (keys != null) {
                while (keys.hasNext()) {
                    String key = String.valueOf(keys.next());
                    errorResponse.put(key, object.getString(key));
                }
            }
            return this.deserializeError(errorResponse);
        }
        catch (JSONException e) {
            throw new SerializationException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public OAuth2Exception deserializeError(Map<String, String> errorParams) {
        String errorMessage;
        String errorCode = errorParams.get("error");
        String string = errorMessage = errorParams.containsKey("error_description") ? errorParams.get("error_description") : null;
        if (errorMessage == null) {
            String string2 = errorMessage = errorCode == null ? "OAuth Error" : errorCode;
        }
        OAuth2Exception ex = "invalid_client".equals(errorCode) ? new InvalidClientException(errorMessage) : ("unauthorized_client".equals(errorCode) ? new UnauthorizedClientException(errorMessage) : ("invalid_grant".equals(errorCode) ? new InvalidGrantException(errorMessage) : ("invalid_scope".equals(errorCode) ? new InvalidScopeException(errorMessage) : ("invalid_token".equals(errorCode) ? new InvalidTokenException(errorMessage) : ("redirect_uri_mismatch".equals(errorCode) ? new RedirectMismatchException(errorMessage) : ("unsupported_grant_type".equals(errorCode) ? new UnsupportedGrantTypeException(errorMessage) : ("unsupported_response_type".equals(errorCode) ? new UnsupportedResponseTypeException(errorMessage) : ("access_denied".equals(errorCode) ? new UserDeniedVerificationException(errorMessage) : new OAuth2Exception(errorMessage)))))))));
        Set<Map.Entry<String, String>> entries = errorParams.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String key = entry.getKey();
            if ("error".equals(key) || "error_description".equals(key)) continue;
            ex.addAdditionalInformation(key, entry.getValue());
        }
        return ex;
    }
}

