/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.provider;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.DecoderException;
import org.springframework.security.oauth.common.OAuthCodec;
import org.springframework.security.oauth.common.OAuthConsumerParameter;
import org.springframework.security.oauth.common.StringSplitUtils;
import org.springframework.security.oauth.provider.OAuthProviderSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreOAuthProviderSupport
implements OAuthProviderSupport {
    private final Set<String> supportedOAuthParameters;
    private String baseUrl = null;

    public CoreOAuthProviderSupport() {
        TreeSet<String> supportedOAuthParameters = new TreeSet<String>();
        for (OAuthConsumerParameter supportedParameter : OAuthConsumerParameter.values()) {
            supportedOAuthParameters.add(supportedParameter.toString());
        }
        this.supportedOAuthParameters = supportedOAuthParameters;
    }

    @Override
    public Map<String, String> parseParameters(HttpServletRequest request) {
        Map<String, String> parameters = this.parseHeaderParameters(request);
        if (parameters == null) {
            parameters = new HashMap<String, String>();
            for (String supportedOAuthParameter : this.getSupportedOAuthParameters()) {
                String param = request.getParameter(supportedOAuthParameter);
                if (param == null) continue;
                parameters.put(supportedOAuthParameter, param);
            }
        }
        return parameters;
    }

    protected Map<String, String> parseHeaderParameters(HttpServletRequest request) {
        String header = null;
        Enumeration headers = request.getHeaders("Authorization");
        while (headers.hasMoreElements()) {
            String value = (String)headers.nextElement();
            if (!value.toLowerCase().startsWith("oauth ")) continue;
            header = value;
            break;
        }
        HashMap<String, String> parameters = null;
        if (header != null) {
            parameters = new HashMap<String, String>();
            String authHeaderValue = header.substring(6);
            String[] headerEntries = StringSplitUtils.splitIgnoringQuotes(authHeaderValue, ',');
            Iterator<Map.Entry<String, String>> i$ = StringSplitUtils.splitEachArrayElementAndCreateMap(headerEntries, "=", "\"").entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry<String, String> o;
                Map.Entry<String, String> entry = o = i$.next();
                try {
                    String key = OAuthCodec.oauthDecode(entry.getKey());
                    String value = OAuthCodec.oauthDecode(entry.getValue());
                    parameters.put(key, value);
                }
                catch (DecoderException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        return parameters;
    }

    protected Set<String> getSupportedOAuthParameters() {
        return this.supportedOAuthParameters;
    }

    @Override
    public String getSignatureBaseString(HttpServletRequest request) {
        SortedMap<String, SortedSet<String>> significantParameters = this.loadSignificantParametersForSignatureBaseString(request);
        StringBuilder queryString = new StringBuilder();
        Iterator<Map.Entry<String, SortedSet<String>>> paramIt = significantParameters.entrySet().iterator();
        while (paramIt.hasNext()) {
            Map.Entry<String, SortedSet<String>> sortedParameter = paramIt.next();
            Iterator valueIt = sortedParameter.getValue().iterator();
            while (valueIt.hasNext()) {
                String parameterValue = (String)valueIt.next();
                queryString.append(sortedParameter.getKey()).append('=').append(parameterValue);
                if (!paramIt.hasNext() && !valueIt.hasNext()) continue;
                queryString.append('&');
            }
        }
        String url = this.getBaseUrl(request);
        if (url == null) {
            url = request.getRequestURL().toString();
        }
        url = this.normalizeUrl(url);
        url = OAuthCodec.oauthEncode(url);
        String method = request.getMethod().toUpperCase();
        return method + '&' + url + '&' + OAuthCodec.oauthEncode(queryString.toString());
    }

    protected String normalizeUrl(String url) {
        try {
            URL requestURL = new URL(url);
            StringBuilder normalized = new StringBuilder(requestURL.getProtocol().toLowerCase()).append("://").append(requestURL.getHost().toLowerCase());
            if (requestURL.getPort() >= 0 && requestURL.getPort() != requestURL.getDefaultPort()) {
                normalized.append(":").append(requestURL.getPort());
            }
            normalized.append(requestURL.getPath());
            return normalized.toString();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Illegal URL for calculating the OAuth signature.", e);
        }
    }

    protected SortedMap<String, SortedSet<String>> loadSignificantParametersForSignatureBaseString(HttpServletRequest request) {
        TreeMap<String, SortedSet<String>> significantParameters = new TreeMap<String, SortedSet<String>>();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            String[] values = request.getParameterValues(parameterName);
            if (values == null) {
                values = new String[]{""};
            }
            parameterName = OAuthCodec.oauthEncode(parameterName);
            for (String parameterValue : values) {
                if (parameterValue == null) {
                    parameterValue = "";
                }
                parameterValue = OAuthCodec.oauthEncode(parameterValue);
                TreeSet<String> significantValues = (TreeSet<String>)significantParameters.get(parameterName);
                if (significantValues == null) {
                    significantValues = new TreeSet<String>();
                    significantParameters.put(parameterName, significantValues);
                }
                significantValues.add(parameterValue);
            }
        }
        Map<String, String> oauthParams = this.parseParameters(request);
        oauthParams.remove("realm");
        Set<String> parsedParams = oauthParams.keySet();
        for (String parameterName : parsedParams) {
            String parameterValue = oauthParams.get(parameterName);
            if (parameterValue == null) {
                parameterValue = "";
            }
            parameterName = OAuthCodec.oauthEncode(parameterName);
            parameterValue = OAuthCodec.oauthEncode(parameterValue);
            TreeSet<String> significantValues = (TreeSet<String>)significantParameters.get(parameterName);
            if (significantValues == null) {
                significantValues = new TreeSet<String>();
                significantParameters.put(parameterName, significantValues);
            }
            significantValues.add(parameterValue);
        }
        significantParameters.remove(OAuthConsumerParameter.oauth_signature.toString());
        return significantParameters;
    }

    protected String getBaseUrl(HttpServletRequest request) {
        String baseUrl = this.getBaseUrl();
        if (baseUrl != null) {
            StringBuilder builder = new StringBuilder(baseUrl);
            String path = request.getRequestURI();
            if (path != null && !"".equals(path)) {
                if (!baseUrl.endsWith("/") && !path.startsWith("/")) {
                    builder.append('/');
                }
                builder.append(path);
            }
            baseUrl = builder.toString();
        }
        return baseUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }
}

