/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.common.exceptions.UnsupportedGrantTypeException;
import org.springframework.security.oauth2.provider.DefaultOAuth2GrantManager;
import org.springframework.security.oauth2.provider.OAuth2AuthorizationSuccessHandler;
import org.springframework.security.oauth2.provider.OAuth2GrantManager;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.util.Assert;

public class OAuth2AuthorizationFilter
extends AbstractAuthenticationProcessingFilter {
    private String defaultGrantType = "authorization_code";
    private OAuth2GrantManager grantManager = new DefaultOAuth2GrantManager();

    public OAuth2AuthorizationFilter() {
        super("/oauth/authorize");
        this.setAuthenticationSuccessHandler(new OAuth2AuthorizationSuccessHandler());
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        return !"none".equals(request.getParameter("grant_type")) && super.requiresAuthentication(request, response);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException, ServletException {
        Authentication authentication;
        String grantType = request.getParameter("grant_type");
        if (grantType == null) {
            grantType = this.getDefaultGrantType();
        }
        if ((authentication = this.getGrantManager().setupAuthentication(grantType, request)) == null) {
            throw new UnsupportedGrantTypeException("Unsupported grant type: " + grantType);
        }
        return this.getAuthenticationManager().authenticate(authentication);
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException, ServletException {
        SecurityContextHolder.clearContext();
        throw failed;
    }

    public String getDefaultGrantType() {
        return this.defaultGrantType;
    }

    public void setDefaultGrantType(String defaultGrantType) {
        this.defaultGrantType = defaultGrantType;
    }

    public OAuth2GrantManager getGrantManager() {
        return this.grantManager;
    }

    public void setGrantManager(OAuth2GrantManager grantManager) {
        this.grantManager = grantManager;
    }

    public void setAuthenticationSuccessHandler(AuthenticationSuccessHandler successHandler) {
        Assert.isTrue((boolean)(successHandler instanceof OAuth2AuthorizationSuccessHandler), (String)"OAuth2 authorization filter must be provided with an OAuth2AuthorizationSuccessHandler.");
        super.setAuthenticationSuccessHandler(successHandler);
    }
}

