/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseClientDetails
implements ClientDetails {
    private String clientId;
    private String clientSecret;
    private List<String> scope;
    private List<String> authorizedGrantTypes;
    private String webServerRedirectUri;
    private List<GrantedAuthority> authorities = Collections.emptyList();

    public BaseClientDetails() {
    }

    public BaseClientDetails(String commaSeparatedScopes, String commaSeparatedAuthorizedGrantTypes, String commaSeparatedAuthorities) {
        List<String> scopeList;
        if (StringUtils.hasText((String)commaSeparatedScopes) && !(scopeList = Arrays.asList(StringUtils.commaDelimitedListToStringArray((String)commaSeparatedScopes))).isEmpty()) {
            this.scope = scopeList;
        }
        this.authorizedGrantTypes = StringUtils.hasText((String)commaSeparatedAuthorizedGrantTypes) ? Arrays.asList(StringUtils.commaDelimitedListToStringArray((String)commaSeparatedAuthorizedGrantTypes)) : Arrays.asList("authorization_code", "refresh_token");
        if (StringUtils.hasText((String)commaSeparatedAuthorities)) {
            this.authorities = AuthorityUtils.commaSeparatedStringToAuthorityList((String)commaSeparatedAuthorities);
        }
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public boolean isSecretRequired() {
        return this.clientSecret != null;
    }

    @Override
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Override
    public boolean isScoped() {
        return this.scope != null && !this.scope.isEmpty();
    }

    @Override
    public List<String> getScope() {
        return this.scope;
    }

    public void setScope(List<String> scope) {
        this.scope = scope;
    }

    @Override
    public List<String> getAuthorizedGrantTypes() {
        return this.authorizedGrantTypes;
    }

    public void setAuthorizedGrantTypes(List<String> authorizedGrantTypes) {
        this.authorizedGrantTypes = authorizedGrantTypes;
    }

    @Override
    public String getWebServerRedirectUri() {
        return this.webServerRedirectUri;
    }

    public void setWebServerRedirectUri(String webServerRedirectUri) {
        this.webServerRedirectUri = webServerRedirectUri;
    }

    @Override
    public List<GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public void setAuthorities(List<GrantedAuthority> authorities) {
        this.authorities = authorities;
    }
}

