/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.consumer;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.security.oauth.common.StringSplitUtils;
import org.springframework.security.oauth2.common.DefaultOAuth2SerializationService;
import org.springframework.security.oauth2.common.OAuth2SerializationService;
import org.springframework.web.client.DefaultResponseErrorHandler;

public class OAuth2ErrorHandler
extends DefaultResponseErrorHandler {
    private OAuth2SerializationService serializationService = new DefaultOAuth2SerializationService();

    public void handleError(ClientHttpResponse response) throws IOException {
        if (response.getStatusCode().value() == 401) {
            List authenticateHeaders = response.getHeaders().get((Object)"WWW-Authenticate");
            for (String authenticateHeader : authenticateHeaders) {
                if (!authenticateHeader.toLowerCase().startsWith("oauth ")) continue;
                Map<String, String> headerEntries = StringSplitUtils.splitEachArrayElementAndCreateMap(StringSplitUtils.splitIgnoringQuotes(authenticateHeader, ','), "=", "\"");
                throw this.getSerializationService().deserializeError(headerEntries);
            }
        }
        super.handleError(response);
    }

    public OAuth2SerializationService getSerializationService() {
        return this.serializationService;
    }

    public void setSerializationService(OAuth2SerializationService serializationService) {
        this.serializationService = serializationService;
    }
}

