/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.common.signature;

import org.springframework.security.oauth.common.signature.InvalidSignatureException;
import org.springframework.security.oauth.common.signature.OAuthSignatureMethod;

public class PlainTextSignatureMethod
implements OAuthSignatureMethod {
    public static final String SIGNATURE_NAME = "PLAINTEXT";
    private final String secret;

    public PlainTextSignatureMethod(String secret) {
        this.secret = secret;
    }

    public String getName() {
        return SIGNATURE_NAME;
    }

    public String sign(String signatureBaseString) {
        return this.secret;
    }

    public void verify(String signatureBaseString, String signature) throws InvalidSignatureException {
        if (!signature.equals(this.secret)) {
            throw new InvalidSignatureException("Invalid signature for signature method " + this.getName());
        }
    }

    public String getSecret() {
        return this.secret;
    }
}

