/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.authserver;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.oauth2.authserver.AuthorizationServerProperties;
import org.springframework.boot.autoconfigure.security.oauth2.authserver.AuthorizationServerTokenServicesConfiguration;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.configuration.AuthenticationConfiguration;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.crypto.password.NoOpPasswordEncoder;
import org.springframework.security.oauth2.config.annotation.builders.ClientDetailsServiceBuilder;
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerEndpointsConfiguration;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableAuthorizationServer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerEndpointsConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.TokenStore;

@Configuration
@ConditionalOnClass(value={EnableAuthorizationServer.class})
@ConditionalOnBean(value={AuthorizationServerEndpointsConfiguration.class})
@EnableConfigurationProperties(value={AuthorizationServerProperties.class})
@Import(value={AuthorizationServerTokenServicesConfiguration.class})
public class OAuth2AuthorizationServerConfiguration {
    private static final Log logger = LogFactory.getLog(OAuth2AuthorizationServerConfiguration.class);

    @Configuration
    @ConditionalOnMissingBean(value={AuthorizationServerConfigurer.class})
    private static class AuthorizationSecurityConfigurer
    extends AuthorizationServerConfigurerAdapter {
        private final BaseClientDetails details;
        private final AuthenticationManager authenticationManager;
        private final TokenStore tokenStore;
        private final AccessTokenConverter tokenConverter;
        private final AuthorizationServerProperties properties;

        public AuthorizationSecurityConfigurer(BaseClientDetails details, AuthenticationConfiguration authenticationConfiguration, ObjectProvider<TokenStore> tokenStore, ObjectProvider<AccessTokenConverter> tokenConverter, AuthorizationServerProperties properties) throws Exception {
            this.details = details;
            this.authenticationManager = authenticationConfiguration.getAuthenticationManager();
            this.tokenStore = (TokenStore)tokenStore.getIfAvailable();
            this.tokenConverter = (AccessTokenConverter)tokenConverter.getIfAvailable();
            this.properties = properties;
        }

        public void configure(ClientDetailsServiceConfigurer clients) throws Exception {
            ClientDetailsServiceBuilder.ClientBuilder builder = clients.inMemory().withClient(this.details.getClientId());
            builder.secret(this.details.getClientSecret()).resourceIds(this.details.getResourceIds().toArray(new String[0])).authorizedGrantTypes(this.details.getAuthorizedGrantTypes().toArray(new String[0])).authorities(AuthorityUtils.authorityListToSet((Collection)this.details.getAuthorities()).toArray(new String[0])).scopes(this.details.getScope().toArray(new String[0]));
            if (this.details.getAutoApproveScopes() != null) {
                builder.autoApprove(this.details.getAutoApproveScopes().toArray(new String[0]));
            }
            if (this.details.getAccessTokenValiditySeconds() != null) {
                builder.accessTokenValiditySeconds(this.details.getAccessTokenValiditySeconds().intValue());
            }
            if (this.details.getRefreshTokenValiditySeconds() != null) {
                builder.refreshTokenValiditySeconds(this.details.getRefreshTokenValiditySeconds().intValue());
            }
            if (this.details.getRegisteredRedirectUri() != null) {
                builder.redirectUris(this.details.getRegisteredRedirectUri().toArray(new String[0]));
            }
        }

        public void configure(AuthorizationServerEndpointsConfigurer endpoints) throws Exception {
            if (this.tokenConverter != null) {
                endpoints.accessTokenConverter(this.tokenConverter);
            }
            if (this.tokenStore != null) {
                endpoints.tokenStore(this.tokenStore);
            }
            if (this.details.getAuthorizedGrantTypes().contains("password")) {
                endpoints.authenticationManager(this.authenticationManager);
            }
        }

        public void configure(AuthorizationServerSecurityConfigurer security) throws Exception {
            security.passwordEncoder(NoOpPasswordEncoder.getInstance());
            if (this.properties.getCheckTokenAccess() != null) {
                security.checkTokenAccess(this.properties.getCheckTokenAccess());
            }
            if (this.properties.getTokenKeyAccess() != null) {
                security.tokenKeyAccess(this.properties.getTokenKeyAccess());
            }
            if (this.properties.getRealm() != null) {
                security.realm(this.properties.getRealm());
            }
        }

        @Configuration
        @ConditionalOnMissingBean(value={BaseClientDetails.class})
        protected static class BaseClientDetailsConfiguration {
            private final OAuth2ClientProperties client;

            protected BaseClientDetailsConfiguration(OAuth2ClientProperties client) {
                this.client = client;
            }

            @Bean
            @ConfigurationProperties(prefix="security.oauth2.client")
            public BaseClientDetails oauth2ClientDetails() {
                BaseClientDetails details = new BaseClientDetails();
                if (this.client.getClientId() == null) {
                    this.client.setClientId(UUID.randomUUID().toString());
                }
                details.setClientId(this.client.getClientId());
                details.setClientSecret(this.client.getClientSecret());
                details.setAuthorizedGrantTypes(Arrays.asList("authorization_code", "password", "client_credentials", "implicit", "refresh_token"));
                details.setAuthorities((Collection)AuthorityUtils.commaSeparatedStringToAuthorityList((String)"ROLE_USER"));
                details.setRegisteredRedirectUri(Collections.emptySet());
                return details;
            }
        }

        @Configuration
        protected static class ClientDetailsLogger
        implements InitializingBean {
            private final OAuth2ClientProperties credentials;

            protected ClientDetailsLogger(OAuth2ClientProperties credentials) {
                this.credentials = credentials;
            }

            public void afterPropertiesSet() {
                this.init();
            }

            public void init() {
                String prefix = "security.oauth2.client";
                boolean defaultSecret = this.credentials.isDefaultSecret();
                logger.info((Object)String.format("Initialized OAuth2 Client%n%n%s.client-id = %s%n%s.client-secret = %s%n%n", prefix, this.credentials.getClientId(), prefix, defaultSecret ? this.credentials.getClientSecret() : "****"));
            }
        }
    }
}

