/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.resource;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.autoconfigure.security.oauth2.resource.ResourceServerTokenServicesConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerEndpointsConfiguration;
import org.springframework.util.StringUtils;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;

@ConfigurationProperties(prefix="security.oauth2.resource")
public class ResourceServerProperties
implements BeanFactoryAware,
InitializingBean {
    @JsonIgnore
    private final String clientId;
    @JsonIgnore
    private final String clientSecret;
    @JsonIgnore
    private ListableBeanFactory beanFactory;
    private String serviceId = "resource";
    private String id;
    private String userInfoUri;
    private String tokenInfoUri;
    private boolean preferTokenInfo = true;
    private String tokenType = "Bearer";
    private Jwt jwt = new Jwt();
    private Jwk jwk = new Jwk();

    public ResourceServerProperties() {
        this(null, null);
    }

    public ResourceServerProperties(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }

    public String getResourceId() {
        return this.id;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUserInfoUri() {
        return this.userInfoUri;
    }

    public void setUserInfoUri(String userInfoUri) {
        this.userInfoUri = userInfoUri;
    }

    public String getTokenInfoUri() {
        return this.tokenInfoUri;
    }

    public void setTokenInfoUri(String tokenInfoUri) {
        this.tokenInfoUri = tokenInfoUri;
    }

    public boolean isPreferTokenInfo() {
        return this.preferTokenInfo;
    }

    public void setPreferTokenInfo(boolean preferTokenInfo) {
        this.preferTokenInfo = preferTokenInfo;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public Jwt getJwt() {
        return this.jwt;
    }

    public void setJwt(Jwt jwt) {
        this.jwt = jwt;
    }

    public Jwk getJwk() {
        return this.jwk;
    }

    public void setJwk(Jwk jwk) {
        this.jwk = jwk;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void afterPropertiesSet() {
        this.validate();
    }

    public void validate() {
        if (this.countBeans(AuthorizationServerEndpointsConfiguration.class) > 0) {
            return;
        }
        if (this.countBeans(ResourceServerTokenServicesConfiguration.class) == 0) {
            return;
        }
        if (!StringUtils.hasText((String)this.clientId)) {
            return;
        }
        try {
            this.doValidate();
        }
        catch (BindException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private int countBeans(Class<?> type) {
        return BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, type, (boolean)true, (boolean)false).length;
    }

    private void doValidate() throws BindException {
        BeanPropertyBindingResult errors = new BeanPropertyBindingResult((Object)this, "resourceServerProperties");
        boolean jwtConfigPresent = StringUtils.hasText((String)this.jwt.getKeyUri()) || StringUtils.hasText((String)this.jwt.getKeyValue());
        boolean jwkConfigPresent = StringUtils.hasText((String)this.jwk.getKeySetUri());
        if (jwtConfigPresent && jwkConfigPresent) {
            errors.reject("ambiguous.keyUri", "Only one of jwt.keyUri (or jwt.keyValue) and jwk.keySetUri should be configured.");
        }
        if (!jwtConfigPresent && !jwkConfigPresent) {
            if (!StringUtils.hasText((String)this.userInfoUri) && !StringUtils.hasText((String)this.tokenInfoUri)) {
                errors.rejectValue("tokenInfoUri", "missing.tokenInfoUri", "Missing tokenInfoUri and userInfoUri and there is no JWT verifier key");
            }
            if (StringUtils.hasText((String)this.tokenInfoUri) && this.isPreferTokenInfo() && !StringUtils.hasText((String)this.clientSecret)) {
                errors.rejectValue("clientSecret", "missing.clientSecret", "Missing client secret");
            }
        }
        if (errors.hasErrors()) {
            throw new BindException((BindingResult)errors);
        }
    }

    public class Jwk {
        private String keySetUri;

        public String getKeySetUri() {
            return this.keySetUri;
        }

        public void setKeySetUri(String keySetUri) {
            this.keySetUri = keySetUri;
        }
    }

    public class Jwt {
        private String keyValue;
        private String keyUri;
        private String keyStore;
        private String keyStorePassword;
        private String keyAlias;
        private String keyPassword;

        public String getKeyValue() {
            return this.keyValue;
        }

        public void setKeyValue(String keyValue) {
            this.keyValue = keyValue;
        }

        public void setKeyUri(String keyUri) {
            this.keyUri = keyUri;
        }

        public String getKeyUri() {
            return this.keyUri;
        }

        public String getKeyStore() {
            return this.keyStore;
        }

        public void setKeyStore(String keyStore) {
            this.keyStore = keyStore;
        }

        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public void setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
        }

        public String getKeyAlias() {
            return this.keyAlias;
        }

        public void setKeyAlias(String keyAlias) {
            this.keyAlias = keyAlias;
        }

        public String getKeyPassword() {
            return this.keyPassword;
        }

        public void setKeyPassword(String keyPassword) {
            this.keyPassword = keyPassword;
        }
    }
}

