/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.extensions.saml2.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Timer;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.HttpClient;
import org.opensaml.Configuration;
import org.opensaml.PaosBootstrap;
import org.opensaml.saml2.metadata.provider.FilesystemMetadataProvider;
import org.opensaml.saml2.metadata.provider.HTTPMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.parse.StaticBasicParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.security.keyinfo.KeyInfoGeneratorFactory;
import org.opensaml.xml.security.keyinfo.NamedKeyInfoGeneratorManager;
import org.opensaml.xml.security.x509.CertPathPKIXTrustEvaluator;
import org.opensaml.xml.security.x509.PKIXTrustEvaluator;
import org.opensaml.xml.security.x509.PKIXValidationInformationResolver;
import org.opensaml.xml.security.x509.X509KeyInfoGeneratorFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.extensions.saml2.config.SAMLDslEntryPoint;
import org.springframework.security.saml.SAMLAuthenticationProvider;
import org.springframework.security.saml.SAMLDiscovery;
import org.springframework.security.saml.SAMLEntryPoint;
import org.springframework.security.saml.SAMLProcessingFilter;
import org.springframework.security.saml.context.SAMLContextProvider;
import org.springframework.security.saml.context.SAMLContextProviderLB;
import org.springframework.security.saml.key.JKSKeyManager;
import org.springframework.security.saml.key.KeyManager;
import org.springframework.security.saml.log.SAMLDefaultLogger;
import org.springframework.security.saml.log.SAMLLogger;
import org.springframework.security.saml.metadata.CachingMetadataManager;
import org.springframework.security.saml.metadata.ExtendedMetadata;
import org.springframework.security.saml.metadata.ExtendedMetadataDelegate;
import org.springframework.security.saml.metadata.MetadataDisplayFilter;
import org.springframework.security.saml.metadata.MetadataGenerator;
import org.springframework.security.saml.metadata.MetadataGeneratorFilter;
import org.springframework.security.saml.metadata.MetadataManager;
import org.springframework.security.saml.processor.HTTPPostBinding;
import org.springframework.security.saml.processor.HTTPRedirectDeflateBinding;
import org.springframework.security.saml.processor.SAMLProcessor;
import org.springframework.security.saml.processor.SAMLProcessorImpl;
import org.springframework.security.saml.trust.MetadataCredentialResolver;
import org.springframework.security.saml.trust.PKIXInformationResolver;
import org.springframework.security.saml.userdetails.SAMLUserDetailsService;
import org.springframework.security.saml.util.VelocityFactory;
import org.springframework.security.saml.websso.WebSSOProfile;
import org.springframework.security.saml.websso.WebSSOProfileConsumer;
import org.springframework.security.saml.websso.WebSSOProfileConsumerImpl;
import org.springframework.security.saml.websso.WebSSOProfileImpl;
import org.springframework.security.saml.websso.WebSSOProfileOptions;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.access.channel.ChannelProcessingFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class SAMLConfigurer
extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity> {
    private IdentityProvider identityProvider = new IdentityProvider();
    private ServiceProvider serviceProvider = new ServiceProvider();
    private WebSSOProfileOptions webSSOProfileOptions = this.webSSOProfileOptions();
    private StaticBasicParserPool parserPool = this.staticBasicParserPool();
    private SAMLProcessor samlProcessor = this.samlProcessor();
    private SAMLDefaultLogger samlLogger = new SAMLDefaultLogger();
    private SAMLAuthenticationProvider samlAuthenticationProvider;
    private MetadataProvider metadataProvider;
    private ExtendedMetadataDelegate extendedMetadataDelegate;
    private CachingMetadataManager cachingMetadataManager;
    private WebSSOProfile webSSOProfile;
    private SAMLUserDetailsService samlUserDetailsService;
    private ObjectPostProcessor<Object> objectPostProcessor = new ObjectPostProcessor<Object>(){

        public <T> T postProcess(T object) {
            return object;
        }
    };

    private SAMLConfigurer() {
    }

    public void init(HttpSecurity http) {
        this.metadataProvider = this.identityProvider.metadataProvider();
        ExtendedMetadata extendedMetadata = this.extendedMetadata(this.identityProvider.discoveryEnabled);
        this.extendedMetadataDelegate = this.extendedMetadataDelegate(extendedMetadata);
        this.serviceProvider.keyManager = this.serviceProvider.keyManager();
        this.cachingMetadataManager = this.cachingMetadataManager();
        this.webSSOProfile = new WebSSOProfileImpl(this.samlProcessor, (MetadataManager)this.cachingMetadataManager);
        this.samlAuthenticationProvider = this.samlAuthenticationProvider();
        this.bootstrap();
        SAMLContextProvider contextProvider = this.contextProvider();
        SAMLEntryPoint samlEntryPoint = this.samlEntryPoint(contextProvider);
        try {
            http.httpBasic().authenticationEntryPoint((AuthenticationEntryPoint)samlEntryPoint);
            CsrfConfigurer csrfConfigurer = (CsrfConfigurer)http.getConfigurer(CsrfConfigurer.class);
            if (csrfConfigurer != null) {
                AntPathRequestMatcher ignored = new AntPathRequestMatcher("/saml/SSO");
                NegatedRequestMatcher notIgnored = new NegatedRequestMatcher((RequestMatcher)ignored);
                AndRequestMatcher matcher = new AndRequestMatcher(new RequestMatcher[]{new DefaultRequiresCsrfMatcher(), notIgnored});
                csrfConfigurer.requireCsrfProtectionMatcher((RequestMatcher)matcher);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        http.addFilterBefore((Filter)this.metadataGeneratorFilter(samlEntryPoint, extendedMetadata), ChannelProcessingFilter.class).addFilterAfter((Filter)this.samlFilter(samlEntryPoint, contextProvider), BasicAuthenticationFilter.class).authenticationProvider((AuthenticationProvider)this.samlAuthenticationProvider);
    }

    public static SAMLConfigurer saml() {
        return new SAMLConfigurer();
    }

    public SAMLConfigurer userDetailsService(SAMLUserDetailsService samlUserDetailsService) {
        this.samlUserDetailsService = samlUserDetailsService;
        return this;
    }

    public IdentityProvider identityProvider() {
        return this.identityProvider;
    }

    public ServiceProvider serviceProvider() {
        return this.serviceProvider;
    }

    private String entityBaseURL() {
        String entityBaseURL = this.serviceProvider.hostName + "/" + this.serviceProvider.basePath;
        entityBaseURL = entityBaseURL.replaceAll("//", "/").replaceAll("/$", "");
        entityBaseURL = this.serviceProvider.protocol + "://" + entityBaseURL;
        return entityBaseURL;
    }

    private SAMLEntryPoint samlEntryPoint(SAMLContextProvider contextProvider) {
        SAMLDslEntryPoint samlEntryPoint = new SAMLDslEntryPoint();
        samlEntryPoint.setDefaultProfileOptions(this.webSSOProfileOptions);
        samlEntryPoint.setWebSSOprofile(this.webSSOProfile);
        samlEntryPoint.setContextProvider(contextProvider);
        samlEntryPoint.setMetadata((MetadataManager)this.cachingMetadataManager);
        samlEntryPoint.setSamlLogger((SAMLLogger)this.samlLogger);
        return samlEntryPoint;
    }

    private SAMLProcessor samlProcessor() {
        ArrayList<Object> bindings = new ArrayList<Object>();
        bindings.add(this.httpRedirectDeflateBinding((ParserPool)this.parserPool));
        bindings.add(this.httpPostBinding((ParserPool)this.parserPool));
        return new SAMLProcessorImpl(bindings);
    }

    private CachingMetadataManager cachingMetadataManager() {
        ArrayList<ExtendedMetadataDelegate> providers = new ArrayList<ExtendedMetadataDelegate>();
        providers.add(this.extendedMetadataDelegate);
        CachingMetadataManager cachingMetadataManager = null;
        try {
            cachingMetadataManager = new CachingMetadataManager(providers);
        }
        catch (MetadataProviderException e) {
            e.printStackTrace();
        }
        cachingMetadataManager.setKeyManager(this.serviceProvider.keyManager);
        return cachingMetadataManager;
    }

    private StaticBasicParserPool staticBasicParserPool() {
        StaticBasicParserPool parserPool = new StaticBasicParserPool();
        try {
            parserPool.initialize();
        }
        catch (XMLParserException e) {
            e.printStackTrace();
        }
        return parserPool;
    }

    private ExtendedMetadataDelegate extendedMetadataDelegate(ExtendedMetadata extendedMetadata) {
        ExtendedMetadataDelegate extendedMetadataDelegate = new ExtendedMetadataDelegate(this.metadataProvider, extendedMetadata);
        extendedMetadataDelegate.setMetadataTrustCheck(false);
        extendedMetadataDelegate.setMetadataRequireSignature(false);
        return extendedMetadataDelegate;
    }

    private ExtendedMetadata extendedMetadata(boolean discoveryEnabled) {
        ExtendedMetadata extendedMetadata = new ExtendedMetadata();
        extendedMetadata.setIdpDiscoveryEnabled(discoveryEnabled);
        extendedMetadata.setSignMetadata(true);
        return extendedMetadata;
    }

    private WebSSOProfileOptions webSSOProfileOptions() {
        WebSSOProfileOptions webSSOProfileOptions = new WebSSOProfileOptions();
        webSSOProfileOptions.setIncludeScoping(Boolean.valueOf(false));
        return webSSOProfileOptions;
    }

    private void bootstrap() {
        try {
            PaosBootstrap.bootstrap();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        NamedKeyInfoGeneratorManager manager = Configuration.getGlobalSecurityConfiguration().getKeyInfoGeneratorManager();
        X509KeyInfoGeneratorFactory generator = new X509KeyInfoGeneratorFactory();
        generator.setEmitEntityCertificate(true);
        generator.setEmitEntityCertificateChain(true);
        manager.registerFactory("MetadataKeyInfoGenerator", (KeyInfoGeneratorFactory)generator);
    }

    private HTTPPostBinding httpPostBinding(ParserPool parserPool) {
        return new HTTPPostBinding(parserPool, VelocityFactory.getEngine());
    }

    private HTTPRedirectDeflateBinding httpRedirectDeflateBinding(ParserPool parserPool) {
        return new HTTPRedirectDeflateBinding(parserPool);
    }

    private SAMLProcessingFilter samlWebSSOProcessingFilter(SAMLAuthenticationProvider samlAuthenticationProvider, SAMLContextProvider contextProvider, SAMLProcessor samlProcessor) throws Exception {
        SAMLProcessingFilter samlWebSSOProcessingFilter = new SAMLProcessingFilter();
        AuthenticationManagerBuilder authenticationManagerBuilder = new AuthenticationManagerBuilder(this.objectPostProcessor);
        authenticationManagerBuilder.authenticationProvider((AuthenticationProvider)samlAuthenticationProvider);
        samlWebSSOProcessingFilter.setAuthenticationManager((AuthenticationManager)authenticationManagerBuilder.build());
        samlWebSSOProcessingFilter.setContextProvider(contextProvider);
        samlWebSSOProcessingFilter.setSAMLProcessor(samlProcessor);
        return samlWebSSOProcessingFilter;
    }

    private MetadataGeneratorFilter metadataGeneratorFilter(SAMLEntryPoint samlEntryPoint, ExtendedMetadata extendedMetadata) {
        MetadataGeneratorFilter metadataGeneratorFilter = new MetadataGeneratorFilter(this.getMetadataGenerator(samlEntryPoint, extendedMetadata));
        metadataGeneratorFilter.setManager((MetadataManager)this.cachingMetadataManager);
        return metadataGeneratorFilter;
    }

    private FilterChainProxy samlFilter(SAMLEntryPoint samlEntryPoint, SAMLContextProvider contextProvider) {
        ArrayList<DefaultSecurityFilterChain> chains = new ArrayList<DefaultSecurityFilterChain>();
        chains.add(new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/saml/login/**"), new Filter[]{samlEntryPoint}));
        chains.add(new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/saml/metadata/**"), new Filter[]{new MetadataDisplayFilter()}));
        try {
            chains.add(new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/saml/SSO/**"), new Filter[]{this.samlWebSSOProcessingFilter(this.samlAuthenticationProvider, contextProvider, this.samlProcessor)}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SAMLDiscovery samlDiscovery = new SAMLDiscovery();
        samlDiscovery.setMetadata((MetadataManager)this.cachingMetadataManager);
        samlDiscovery.setContextProvider(contextProvider);
        chains.add(new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/saml/discovery/**"), new Filter[]{samlDiscovery}));
        return new FilterChainProxy(chains);
    }

    private SAMLAuthenticationProvider samlAuthenticationProvider() {
        SAMLAuthenticationProvider samlAuthenticationProvider = new SAMLAuthenticationProvider();
        samlAuthenticationProvider.setForcePrincipalAsString(false);
        samlAuthenticationProvider.setSamlLogger((SAMLLogger)this.samlLogger);
        samlAuthenticationProvider.setConsumer((WebSSOProfileConsumer)new WebSSOProfileConsumerImpl());
        samlAuthenticationProvider.setUserDetails(this.samlUserDetailsService);
        return samlAuthenticationProvider;
    }

    private SAMLContextProvider contextProvider() {
        SAMLContextProviderLB contextProvider = new SAMLContextProviderLB();
        contextProvider.setMetadata((MetadataManager)this.cachingMetadataManager);
        contextProvider.setScheme(this.serviceProvider.protocol);
        contextProvider.setServerName(this.serviceProvider.hostName);
        contextProvider.setContextPath(this.serviceProvider.basePath);
        contextProvider.setKeyManager(this.serviceProvider.keyManager);
        MetadataCredentialResolver resolver = new MetadataCredentialResolver((MetadataManager)this.cachingMetadataManager, this.serviceProvider.keyManager);
        CertPathPKIXTrustEvaluator pkixTrustEvaluator = new CertPathPKIXTrustEvaluator();
        PKIXInformationResolver pkixInformationResolver = new PKIXInformationResolver((org.opensaml.security.MetadataCredentialResolver)resolver, (MetadataManager)this.cachingMetadataManager, this.serviceProvider.keyManager);
        contextProvider.setPkixResolver((PKIXValidationInformationResolver)pkixInformationResolver);
        contextProvider.setPkixTrustEvaluator((PKIXTrustEvaluator)pkixTrustEvaluator);
        contextProvider.setMetadataResolver((org.opensaml.security.MetadataCredentialResolver)resolver);
        return contextProvider;
    }

    private MetadataGenerator getMetadataGenerator(SAMLEntryPoint samlEntryPoint, ExtendedMetadata extendedMetadata) {
        MetadataGenerator metadataGenerator = new MetadataGenerator();
        metadataGenerator.setSamlEntryPoint(samlEntryPoint);
        metadataGenerator.setEntityBaseURL(this.entityBaseURL());
        metadataGenerator.setKeyManager(this.serviceProvider.keyManager);
        metadataGenerator.setEntityId(this.serviceProvider.entityId);
        metadataGenerator.setIncludeDiscoveryExtension(false);
        metadataGenerator.setExtendedMetadata(extendedMetadata);
        return metadataGenerator;
    }

    private static final class DefaultRequiresCsrfMatcher
    implements RequestMatcher {
        private Pattern allowedMethods = Pattern.compile("^(GET|HEAD|TRACE|OPTIONS)$");

        private DefaultRequiresCsrfMatcher() {
        }

        public boolean matches(HttpServletRequest request) {
            return !this.allowedMethods.matcher(request.getMethod()).matches();
        }
    }

    public class ServiceProvider {
        private KeyStore keyStore = new KeyStore();
        private KeyManager keyManager;
        private String protocol;
        private String hostName;
        private String basePath;
        private String entityId;

        public ServiceProvider protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public ServiceProvider hostname(String hostname) {
            this.hostName = hostname;
            return this;
        }

        public ServiceProvider basePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public ServiceProvider entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public KeyStore keyStore() {
            return this.keyStore;
        }

        public SAMLConfigurer and() {
            return SAMLConfigurer.this;
        }

        private KeyManager keyManager() {
            DefaultResourceLoader loader = new DefaultResourceLoader();
            Resource storeFile = loader.getResource(this.keyStore.getStoreFilePath());
            HashMap<String, String> passwords = new HashMap<String, String>();
            passwords.put(this.keyStore.getKeyname(), this.keyStore.getKeyPassword());
            return new JKSKeyManager(storeFile, this.keyStore.getPassword(), passwords, this.keyStore.getKeyname());
        }

        public class KeyStore {
            private String storeFilePath;
            private String password;
            private String keyname;
            private String keyPassword;

            public KeyStore storeFilePath(String storeFilePath) {
                this.storeFilePath = storeFilePath;
                return this;
            }

            public KeyStore password(String password) {
                this.password = password;
                return this;
            }

            public KeyStore keyname(String keyname) {
                this.keyname = keyname;
                return this;
            }

            public KeyStore keyPassword(String keyPasswordword) {
                this.keyPassword = keyPasswordword;
                return this;
            }

            public ServiceProvider and() {
                return ServiceProvider.this;
            }

            public String getStoreFilePath() {
                return this.storeFilePath;
            }

            public String getPassword() {
                return this.password;
            }

            public String getKeyname() {
                return this.keyname;
            }

            public String getKeyPassword() {
                return this.keyPassword;
            }

            public String toString() {
                return "KeyStore{storeFilePath='" + this.storeFilePath + '\'' + ", password='" + this.password + '\'' + ", keyname='" + this.keyname + '\'' + ", keyPassword='" + this.keyPassword + '\'' + '}';
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                KeyStore keyStore = (KeyStore)o;
                if (this.storeFilePath != null ? !this.storeFilePath.equals(keyStore.storeFilePath) : keyStore.storeFilePath != null) {
                    return false;
                }
                if (this.password != null ? !this.password.equals(keyStore.password) : keyStore.password != null) {
                    return false;
                }
                if (this.keyname != null ? !this.keyname.equals(keyStore.keyname) : keyStore.keyname != null) {
                    return false;
                }
                return this.keyPassword != null ? this.keyPassword.equals(keyStore.keyPassword) : keyStore.keyPassword == null;
            }

            public int hashCode() {
                int result = this.storeFilePath != null ? this.storeFilePath.hashCode() : 0;
                result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
                result = 31 * result + (this.keyname != null ? this.keyname.hashCode() : 0);
                result = 31 * result + (this.keyPassword != null ? this.keyPassword.hashCode() : 0);
                return result;
            }
        }
    }

    public class IdentityProvider {
        private String metadataFilePath;
        private boolean discoveryEnabled = true;

        public IdentityProvider metadataFilePath(String metadataFilePath) {
            this.metadataFilePath = metadataFilePath;
            return this;
        }

        public IdentityProvider discoveryEnabled(boolean discoveryEnabled) {
            this.discoveryEnabled = discoveryEnabled;
            return this;
        }

        private MetadataProvider metadataProvider() {
            if (this.metadataFilePath.startsWith("http")) {
                return this.httpMetadataProvider();
            }
            return this.fileSystemMetadataProvider();
        }

        private HTTPMetadataProvider httpMetadataProvider() {
            try {
                HTTPMetadataProvider httpMetadataProvider = new HTTPMetadataProvider(new Timer(), new HttpClient(), this.metadataFilePath);
                httpMetadataProvider.setParserPool((ParserPool)SAMLConfigurer.this.parserPool);
                return httpMetadataProvider;
            }
            catch (MetadataProviderException e) {
                e.printStackTrace();
                return null;
            }
        }

        private FilesystemMetadataProvider fileSystemMetadataProvider() {
            DefaultResourceLoader loader = new DefaultResourceLoader();
            Resource metadataResource = loader.getResource(this.metadataFilePath);
            File samlMetadata = null;
            try {
                samlMetadata = metadataResource.getFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            FilesystemMetadataProvider filesystemMetadataProvider = null;
            try {
                filesystemMetadataProvider = new FilesystemMetadataProvider(samlMetadata);
            }
            catch (MetadataProviderException e) {
                e.printStackTrace();
            }
            filesystemMetadataProvider.setParserPool((ParserPool)SAMLConfigurer.this.parserPool);
            return filesystemMetadataProvider;
        }

        public SAMLConfigurer and() {
            return SAMLConfigurer.this;
        }
    }
}

