/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.jcr.config;

import java.util.List;
import javax.jcr.observation.Event;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.core.Constants;
import org.springframework.extensions.jcr.EventListenerDefinition;
import org.springframework.extensions.jcr.JcrSessionFactory;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class JcrNamespaceHandler
extends NamespaceHandlerSupport {
    public void init() {
        this.registerBeanDefinitionParser("eventListenerDefinition", (BeanDefinitionParser)new JcrEventListenerBeanDefinitionParser());
        this.registerBeanDefinitionParser("sessionFactory", (BeanDefinitionParser)new JcrSessionFactoryBeanDefinitionParser());
    }

    private class JcrSessionFactoryBeanDefinitionParser
    extends AbstractSimpleBeanDefinitionParser {
        private JcrSessionFactoryBeanDefinitionParser() {
        }

        protected Class getBeanClass(Element element) {
            return JcrSessionFactory.class;
        }
    }

    private class JcrEventListenerBeanDefinitionParser
    extends AbstractSimpleBeanDefinitionParser {
        public static final String EVENT_TYPE = "eventType";
        public static final String NODE_TYPE_NAME = "nodeTypeName";
        public static final String UUID = "uuid";

        private JcrEventListenerBeanDefinitionParser() {
        }

        protected Class getBeanClass(Element element) {
            return EventListenerDefinition.class;
        }

        protected void postProcess(BeanDefinitionBuilder definitionBuilder, Element element) {
            List eventTypes = DomUtils.getChildElementsByTagName((Element)element, (String)EVENT_TYPE);
            if (eventTypes != null && eventTypes.size() > 0) {
                int eventType = 0;
                Constants types = new Constants(Event.class);
                for (Element evenTypeElement : eventTypes) {
                    eventType |= types.asNumber(DomUtils.getTextValue((Element)evenTypeElement)).intValue();
                }
                definitionBuilder.addPropertyValue(EVENT_TYPE, (Object)new Integer(eventType));
            }
            List nodeTypeNames = DomUtils.getChildElementsByTagName((Element)element, (String)NODE_TYPE_NAME);
            String[] nodeTypeValues = new String[nodeTypeNames.size()];
            for (int i = 0; i < nodeTypeValues.length; ++i) {
                nodeTypeValues[i] = DomUtils.getTextValue((Element)((Element)nodeTypeNames.get(i)));
            }
            definitionBuilder.addPropertyValue(NODE_TYPE_NAME, (Object)nodeTypeValues);
            List uuids = DomUtils.getChildElementsByTagName((Element)element, (String)UUID);
            String[] uuidsValues = new String[uuids.size()];
            for (int i = 0; i < uuidsValues.length; ++i) {
                uuidsValues[i] = DomUtils.getTextValue((Element)((Element)uuids.get(i)));
            }
            definitionBuilder.addPropertyValue(UUID, (Object)uuidsValues);
        }
    }
}

