/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.jcr;

import java.io.IOException;
import javax.jcr.RepositoryException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.extensions.jcr.SessionFactory;
import org.springframework.extensions.jcr.SessionFactoryUtils;

public abstract class JcrAccessor
implements InitializingBean {
    private SessionFactory sessionFactory;

    public void afterPropertiesSet() {
        if (this.getSessionFactory() == null) {
            throw new IllegalArgumentException("sessionFactory is required");
        }
    }

    public DataAccessException convertJcrAccessException(RepositoryException ex) {
        return SessionFactoryUtils.translateException(ex);
    }

    public DataAccessException convertJcrAccessException(IOException ex) {
        return SessionFactoryUtils.translateException(ex);
    }

    public RuntimeException convertJcrAccessException(RuntimeException ex) {
        return ex;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

