/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.snippet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.springframework.util.StringUtils;

class DocumentationProperties {
    private final Properties properties = new Properties();

    DocumentationProperties() {
        try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream("documentation.properties");){
            if (stream != null) {
                this.properties.load(stream);
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to read documentation.properties", ex);
        }
        this.properties.putAll((Map<?, ?>)System.getProperties());
    }

    File getOutputDir() {
        String outputDir = this.properties.getProperty("org.springframework.restdocs.outputDir");
        if (StringUtils.hasText((String)outputDir)) {
            return new File(outputDir).getAbsoluteFile();
        }
        return null;
    }
}

