/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.response;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.springframework.restdocs.response.ContentModifyingReponsePostProcessor;
import org.springframework.util.StringUtils;

class PrettyPrintingResponsePostProcessor
extends ContentModifyingReponsePostProcessor {
    private static final List<PrettyPrinter> PRETTY_PRINTERS = Collections.unmodifiableList(Arrays.asList(new JsonPrettyPrinter(), new XmlPrettyPrinter()));

    PrettyPrintingResponsePostProcessor() {
    }

    @Override
    protected String modifyContent(String originalContent) {
        if (StringUtils.hasText((String)originalContent)) {
            for (PrettyPrinter prettyPrinter : PRETTY_PRINTERS) {
                try {
                    return prettyPrinter.prettyPrint(originalContent);
                }
                catch (Exception exception) {
                }
            }
        }
        return originalContent;
    }

    private static final class JsonPrettyPrinter
    implements PrettyPrinter {
        private JsonPrettyPrinter() {
        }

        @Override
        public String prettyPrint(String original) throws IOException {
            ObjectMapper objectMapper = new ObjectMapper().configure(SerializationFeature.INDENT_OUTPUT, true);
            return objectMapper.writeValueAsString((Object)objectMapper.readTree(original));
        }
    }

    private static final class XmlPrettyPrinter
    implements PrettyPrinter {
        private XmlPrettyPrinter() {
        }

        @Override
        public String prettyPrint(String original) throws Exception {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("doctype-public", "yes");
            StringWriter transformed = new StringWriter();
            transformer.transform(new StreamSource(new StringReader(original)), new StreamResult(transformed));
            return transformed.toString();
        }
    }

    private static interface PrettyPrinter {
        public String prettyPrint(String var1) throws Exception;
    }
}

