/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.response;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.restdocs.response.ContentModifyingReponsePostProcessor;

class PatternReplacingResponsePostProcessor
extends ContentModifyingReponsePostProcessor {
    private final Pattern pattern;
    private final String replacement;

    PatternReplacingResponsePostProcessor(Pattern pattern, String replacement) {
        this.pattern = pattern;
        this.replacement = replacement;
    }

    @Override
    protected String modifyContent(String originalContent) {
        Matcher matcher = this.pattern.matcher(originalContent);
        StringBuilder buffer = new StringBuilder();
        int previous = 0;
        while (matcher.find()) {
            buffer.append(originalContent.substring(previous, matcher.start(1)));
            buffer.append(this.replacement);
            previous = matcher.end(1);
        }
        if (previous < originalContent.length()) {
            buffer.append(originalContent.substring(previous));
        }
        return buffer.toString();
    }
}

