/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.response;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.restdocs.response.ResponsePostProcessor;
import org.springframework.util.ReflectionUtils;

class HeaderRemovingResponsePostProcessor
implements ResponsePostProcessor {
    private final Set<String> headersToRemove;

    public HeaderRemovingResponsePostProcessor(String ... headersToRemove) {
        this.headersToRemove = new HashSet<String>(Arrays.asList(headersToRemove));
    }

    @Override
    public MockHttpServletResponse postProcess(MockHttpServletResponse response) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(MockHttpServletResponse.class);
        enhancer.setCallback((Callback)new HeaderHidingMethodInterceptor(this.headersToRemove, response));
        return (MockHttpServletResponse)enhancer.create();
    }

    private static final class HeaderHidingMethodInterceptor
    implements MethodInterceptor {
        private final MockHttpServletResponse response;
        private final List<Method> interceptedMethods = Arrays.asList(HeaderHidingMethodInterceptor.findHeaderMethod("containsHeader", String.class), HeaderHidingMethodInterceptor.findHeaderMethod("getHeader", String.class), HeaderHidingMethodInterceptor.findHeaderMethod("getHeaderValue", String.class), HeaderHidingMethodInterceptor.findHeaderMethod("getHeaders", String.class), HeaderHidingMethodInterceptor.findHeaderMethod("getHeaderValues", String.class));
        private final Method getHeaderNamesMethod = HeaderHidingMethodInterceptor.findHeaderMethod("getHeaderNames", new Class[0]);
        private final Set<String> hiddenHeaders;

        private HeaderHidingMethodInterceptor(Set<String> hiddenHeaders, MockHttpServletResponse response) {
            this.hiddenHeaders = hiddenHeaders;
            this.response = response;
        }

        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws IllegalAccessException, InvocationTargetException {
            if (this.getHeaderNamesMethod.equals(method)) {
                ArrayList<String> headerNames = new ArrayList<String>();
                for (String candidate : this.response.getHeaderNames()) {
                    if (this.isHiddenHeader(candidate)) continue;
                    headerNames.add(candidate);
                }
                return headerNames;
            }
            if (this.interceptedMethods.contains(method) && this.isHiddenHeader(args)) {
                if (method.getReturnType().equals(Boolean.TYPE)) {
                    return false;
                }
                if (Collection.class.isAssignableFrom(method.getReturnType())) {
                    return Collections.emptyList();
                }
                return null;
            }
            return method.invoke((Object)this.response, args);
        }

        private boolean isHiddenHeader(Object[] args) {
            if (args.length == 1 && args[0] instanceof String) {
                return this.isHiddenHeader((String)args[0]);
            }
            return false;
        }

        private boolean isHiddenHeader(String headerName) {
            for (String hiddenHeader : this.hiddenHeaders) {
                if (!hiddenHeader.equalsIgnoreCase(headerName)) continue;
                return true;
            }
            return false;
        }

        private static Method findHeaderMethod(String methodName, Class<?> ... args) {
            Method candidate = ReflectionUtils.findMethod(MockHttpServletResponse.class, (String)methodName, (Class[])args);
            if (candidate.isBridge()) {
                return BridgeMethodResolver.findBridgedMethod((Method)candidate);
            }
            return candidate;
        }
    }
}

