/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.request;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.restdocs.request.ParameterDescriptor;
import org.springframework.restdocs.snippet.DocumentationWriter;
import org.springframework.restdocs.snippet.SnippetGenerationException;
import org.springframework.restdocs.snippet.SnippetWritingResultHandler;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.util.Assert;

public class QueryParametersSnippetResultHandler
extends SnippetWritingResultHandler {
    private final Map<String, ParameterDescriptor> descriptorsByName = new LinkedHashMap<String, ParameterDescriptor>();

    protected QueryParametersSnippetResultHandler(String outputDir, ParameterDescriptor ... descriptors) {
        super(outputDir, "query-parameters");
        for (ParameterDescriptor descriptor : descriptors) {
            Assert.hasText((String)descriptor.getName());
            Assert.hasText((String)descriptor.getDescription());
            this.descriptorsByName.put(descriptor.getName(), descriptor);
        }
    }

    @Override
    protected void handle(MvcResult result, DocumentationWriter writer) throws IOException {
        this.verifyParameterDescriptors(result);
        this.documentParameters(writer);
    }

    private void verifyParameterDescriptors(MvcResult result) {
        Set actualParameters = result.getRequest().getParameterMap().keySet();
        Set<String> expectedParameters = this.descriptorsByName.keySet();
        HashSet undocumentedParameters = new HashSet(actualParameters);
        undocumentedParameters.removeAll(expectedParameters);
        HashSet<String> missingParameters = new HashSet<String>(expectedParameters);
        missingParameters.removeAll(actualParameters);
        if (!undocumentedParameters.isEmpty() || !missingParameters.isEmpty()) {
            String message = "";
            if (!undocumentedParameters.isEmpty()) {
                message = message + "Query parameters with the following names were not documented: " + undocumentedParameters;
            }
            if (!missingParameters.isEmpty()) {
                if (message.length() > 0) {
                    message = message + ". ";
                }
                message = message + "Query parameters with the following names were not found in the request: " + missingParameters;
            }
            throw new SnippetGenerationException(message);
        }
        Assert.isTrue((boolean)actualParameters.equals(expectedParameters));
    }

    private void documentParameters(DocumentationWriter writer) throws IOException {
        writer.table(new DocumentationWriter.TableAction(){

            @Override
            public void perform(DocumentationWriter.TableWriter tableWriter) throws IOException {
                tableWriter.headers("Parameter", "Description");
                for (Map.Entry entry : QueryParametersSnippetResultHandler.this.descriptorsByName.entrySet()) {
                    tableWriter.row((String)entry.getKey(), ((ParameterDescriptor)entry.getValue()).getDescription());
                }
            }
        });
    }
}

