/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.payload;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.restdocs.payload.FieldDescriptor;
import org.springframework.restdocs.payload.FieldPath;
import org.springframework.restdocs.payload.FieldProcessor;
import org.springframework.restdocs.snippet.SnippetGenerationException;

class FieldValidator {
    private final FieldProcessor fieldProcessor = new FieldProcessor();
    private final ObjectMapper objectMapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);

    FieldValidator() {
    }

    void validate(Reader payloadReader, List<FieldDescriptor> fieldDescriptors) throws IOException {
        Object payload = this.objectMapper.readValue(payloadReader, Object.class);
        List<String> missingFields = this.findMissingFields(payload, fieldDescriptors);
        Object undocumentedPayload = this.findUndocumentedFields(payload, fieldDescriptors);
        if (!missingFields.isEmpty() || !this.isEmpty(undocumentedPayload)) {
            String message = "";
            if (!this.isEmpty(undocumentedPayload)) {
                message = message + String.format("The following parts of the payload were not documented:%n%s", this.objectMapper.writeValueAsString(undocumentedPayload));
            }
            if (!missingFields.isEmpty()) {
                if (message.length() > 0) {
                    message = message + String.format("%n", new Object[0]);
                }
                message = message + "Fields with the following paths were not found in the payload: " + missingFields;
            }
            throw new SnippetGenerationException(message);
        }
    }

    private boolean isEmpty(Object object) {
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        return ((List)object).isEmpty();
    }

    private List<String> findMissingFields(Object payload, List<FieldDescriptor> fieldDescriptors) {
        ArrayList<String> missingFields = new ArrayList<String>();
        for (FieldDescriptor fieldDescriptor : fieldDescriptors) {
            if (fieldDescriptor.isOptional() || this.fieldProcessor.hasField(FieldPath.compile(fieldDescriptor.getPath()), payload)) continue;
            missingFields.add(fieldDescriptor.getPath());
        }
        return missingFields;
    }

    private Object findUndocumentedFields(Object payload, List<FieldDescriptor> fieldDescriptors) {
        for (FieldDescriptor fieldDescriptor : fieldDescriptors) {
            FieldPath path = FieldPath.compile(fieldDescriptor.getPath());
            this.fieldProcessor.remove(path, payload);
        }
        return payload;
    }
}

