/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.payload;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.restdocs.payload.FieldDescriptor;
import org.springframework.restdocs.payload.FieldType;
import org.springframework.restdocs.payload.FieldTypeResolver;
import org.springframework.restdocs.payload.FieldValidator;
import org.springframework.restdocs.snippet.DocumentationWriter;
import org.springframework.restdocs.snippet.SnippetWritingResultHandler;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.util.Assert;

public abstract class FieldSnippetResultHandler
extends SnippetWritingResultHandler {
    private final Map<String, FieldDescriptor> descriptorsByPath = new LinkedHashMap<String, FieldDescriptor>();
    private final FieldTypeResolver fieldTypeResolver = new FieldTypeResolver();
    private final FieldValidator fieldValidator = new FieldValidator();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private List<FieldDescriptor> fieldDescriptors;

    FieldSnippetResultHandler(String outputDir, String filename, List<FieldDescriptor> descriptors) {
        super(outputDir, filename + "-fields");
        for (FieldDescriptor descriptor : descriptors) {
            Assert.notNull((Object)descriptor.getPath());
            Assert.hasText((String)descriptor.getDescription());
            this.descriptorsByPath.put(descriptor.getPath(), descriptor);
        }
        this.fieldDescriptors = descriptors;
    }

    @Override
    protected void handle(MvcResult result, DocumentationWriter writer) throws IOException {
        this.fieldValidator.validate(this.getPayloadReader(result), this.fieldDescriptors);
        final Object payload = this.extractPayload(result);
        writer.table(new DocumentationWriter.TableAction(){

            @Override
            public void perform(DocumentationWriter.TableWriter tableWriter) throws IOException {
                tableWriter.headers("Path", "Type", "Description");
                for (Map.Entry entry : FieldSnippetResultHandler.this.descriptorsByPath.entrySet()) {
                    FieldDescriptor descriptor = (FieldDescriptor)entry.getValue();
                    FieldType type = descriptor.getType() != null ? descriptor.getType() : FieldSnippetResultHandler.this.fieldTypeResolver.resolveFieldType(descriptor.getPath(), payload);
                    tableWriter.row(((String)entry.getKey()).toString(), type.toString(), ((FieldDescriptor)entry.getValue()).getDescription());
                }
            }
        });
    }

    private Object extractPayload(MvcResult result) throws IOException {
        return this.objectMapper.readValue(this.getPayloadReader(result), Object.class);
    }

    protected abstract Reader getPayloadReader(MvcResult var1) throws IOException;
}

