/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.hypermedia;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.restdocs.hypermedia.Link;
import org.springframework.restdocs.hypermedia.LinkDescriptor;
import org.springframework.restdocs.hypermedia.LinkExtractor;
import org.springframework.restdocs.hypermedia.LinkExtractors;
import org.springframework.restdocs.snippet.DocumentationWriter;
import org.springframework.restdocs.snippet.SnippetGenerationException;
import org.springframework.restdocs.snippet.SnippetWritingResultHandler;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.util.Assert;

public class LinkSnippetResultHandler
extends SnippetWritingResultHandler {
    private final Map<String, LinkDescriptor> descriptorsByRel = new LinkedHashMap<String, LinkDescriptor>();
    private final Set<String> requiredRels = new HashSet<String>();
    private final LinkExtractor extractor;

    LinkSnippetResultHandler(String outputDir, LinkExtractor linkExtractor, List<LinkDescriptor> descriptors) {
        super(outputDir, "links");
        this.extractor = linkExtractor;
        for (LinkDescriptor descriptor : descriptors) {
            Assert.hasText((String)descriptor.getRel());
            Assert.hasText((String)descriptor.getDescription());
            this.descriptorsByRel.put(descriptor.getRel(), descriptor);
            if (descriptor.isOptional()) continue;
            this.requiredRels.add(descriptor.getRel());
        }
    }

    @Override
    protected void handle(MvcResult result, DocumentationWriter writer) throws IOException {
        this.validate(this.extractLinks(result));
        this.writeDocumentationSnippet(writer);
    }

    private Map<String, List<Link>> extractLinks(MvcResult result) throws IOException {
        if (this.extractor != null) {
            return this.extractor.extractLinks(result.getResponse());
        }
        String contentType = result.getResponse().getContentType();
        LinkExtractor extractorForContentType = LinkExtractors.extractorForContentType(contentType);
        if (extractorForContentType != null) {
            return extractorForContentType.extractLinks(result.getResponse());
        }
        throw new IllegalStateException("No LinkExtractor has been provided and one is not available for the content type " + contentType);
    }

    private void validate(Map<String, List<Link>> links) {
        Set<String> actualRels = links.keySet();
        HashSet<String> undocumentedRels = new HashSet<String>(actualRels);
        undocumentedRels.removeAll(this.descriptorsByRel.keySet());
        HashSet<String> missingRels = new HashSet<String>(this.requiredRels);
        missingRels.removeAll(actualRels);
        if (!undocumentedRels.isEmpty() || !missingRels.isEmpty()) {
            String message = "";
            if (!undocumentedRels.isEmpty()) {
                message = message + "Links with the following relations were not documented: " + undocumentedRels;
            }
            if (!missingRels.isEmpty()) {
                if (message.length() > 0) {
                    message = message + ". ";
                }
                message = message + "Links with the following relations were not found in the response: " + missingRels;
            }
            throw new SnippetGenerationException(message);
        }
    }

    private void writeDocumentationSnippet(DocumentationWriter writer) throws IOException {
        writer.table(new DocumentationWriter.TableAction(){

            @Override
            public void perform(DocumentationWriter.TableWriter tableWriter) throws IOException {
                tableWriter.headers("Relation", "Description");
                for (Map.Entry entry : LinkSnippetResultHandler.this.descriptorsByRel.entrySet()) {
                    tableWriter.row((String)entry.getKey(), ((LinkDescriptor)entry.getValue()).getDescription());
                }
            }
        });
    }
}

