/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.hypermedia;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.restdocs.hypermedia.Link;
import org.springframework.restdocs.hypermedia.LinkExtractor;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public abstract class LinkExtractors {
    private LinkExtractors() {
    }

    public static LinkExtractor halLinks() {
        return new HalLinkExtractor();
    }

    public static LinkExtractor atomLinks() {
        return new AtomLinkExtractor();
    }

    public static LinkExtractor extractorForContentType(String contentType) {
        if (StringUtils.hasText((String)contentType)) {
            MediaType mediaType = MediaType.parseMediaType((String)contentType);
            if (mediaType.isCompatibleWith(MediaType.APPLICATION_JSON)) {
                return LinkExtractors.atomLinks();
            }
            if (mediaType.isCompatibleWith(HalLinkExtractor.HAL_MEDIA_TYPE)) {
                return LinkExtractors.halLinks();
            }
        }
        return null;
    }

    static class AtomLinkExtractor
    extends JsonContentLinkExtractor {
        AtomLinkExtractor() {
        }

        @Override
        public Map<String, List<Link>> extractLinks(Map<String, Object> json) {
            LinkedMultiValueMap extractedLinks = new LinkedMultiValueMap();
            Object possibleLinks = json.get("links");
            if (possibleLinks instanceof Collection) {
                Collection linksCollection = (Collection)possibleLinks;
                for (Object linkObject : linksCollection) {
                    if (!(linkObject instanceof Map)) continue;
                    Link link = AtomLinkExtractor.maybeCreateLink((Map)linkObject);
                    AtomLinkExtractor.maybeStoreLink(link, (MultiValueMap<String, Link>)extractedLinks);
                }
            }
            return extractedLinks;
        }

        private static Link maybeCreateLink(Map<String, Object> linkMap) {
            Object hrefObject = linkMap.get("href");
            Object relObject = linkMap.get("rel");
            if (relObject instanceof String && hrefObject instanceof String) {
                return new Link((String)relObject, (String)hrefObject);
            }
            return null;
        }

        private static void maybeStoreLink(Link link, MultiValueMap<String, Link> extractedLinks) {
            if (link != null) {
                extractedLinks.add((Object)link.getRel(), (Object)link);
            }
        }
    }

    static class HalLinkExtractor
    extends JsonContentLinkExtractor {
        private static final MediaType HAL_MEDIA_TYPE = new MediaType("application", "hal+json");

        HalLinkExtractor() {
        }

        @Override
        public Map<String, List<Link>> extractLinks(Map<String, Object> json) {
            LinkedHashMap<String, List<Link>> extractedLinks = new LinkedHashMap<String, List<Link>>();
            Object possibleLinks = json.get("_links");
            if (possibleLinks instanceof Map) {
                Map links = (Map)possibleLinks;
                for (Map.Entry entry : links.entrySet()) {
                    String rel = (String)entry.getKey();
                    extractedLinks.put(rel, HalLinkExtractor.convertToLinks(entry.getValue(), rel));
                }
            }
            return extractedLinks;
        }

        private static List<Link> convertToLinks(Object object, String rel) {
            ArrayList<Link> links = new ArrayList<Link>();
            if (object instanceof Collection) {
                Collection hrefObjects = (Collection)object;
                for (Object hrefObject : hrefObjects) {
                    HalLinkExtractor.maybeAddLink(HalLinkExtractor.maybeCreateLink(rel, hrefObject), links);
                }
            } else {
                HalLinkExtractor.maybeAddLink(HalLinkExtractor.maybeCreateLink(rel, object), links);
            }
            return links;
        }

        private static Link maybeCreateLink(String rel, Object possibleHref) {
            if (possibleHref instanceof String) {
                return new Link(rel, (String)possibleHref);
            }
            return null;
        }

        private static void maybeAddLink(Link possibleLink, List<Link> links) {
            if (possibleLink != null) {
                links.add(possibleLink);
            }
        }
    }

    private static abstract class JsonContentLinkExtractor
    implements LinkExtractor {
        private final ObjectMapper objectMapper = new ObjectMapper();

        private JsonContentLinkExtractor() {
        }

        @Override
        public Map<String, List<Link>> extractLinks(MockHttpServletResponse response) throws IOException {
            Map jsonContent = (Map)this.objectMapper.readValue(response.getContentAsString(), Map.class);
            return this.extractLinks(jsonContent);
        }

        protected abstract Map<String, List<Link>> extractLinks(Map<String, Object> var1);
    }
}

