/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs;

import java.util.ArrayList;
import java.util.List;
import org.springframework.restdocs.curl.CurlDocumentation;
import org.springframework.restdocs.http.HttpDocumentation;
import org.springframework.restdocs.hypermedia.HypermediaDocumentation;
import org.springframework.restdocs.hypermedia.LinkDescriptor;
import org.springframework.restdocs.hypermedia.LinkExtractor;
import org.springframework.restdocs.payload.FieldDescriptor;
import org.springframework.restdocs.payload.PayloadDocumentation;
import org.springframework.restdocs.request.ParameterDescriptor;
import org.springframework.restdocs.request.RequestDocumentation;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultHandler;

public class RestDocumentationResultHandler
implements ResultHandler {
    private final String outputDir;
    private List<ResultHandler> delegates = new ArrayList<ResultHandler>();

    RestDocumentationResultHandler(String outputDir) {
        this.outputDir = outputDir;
        this.delegates = new ArrayList<ResultHandler>();
        this.delegates.add(CurlDocumentation.documentCurlRequest(this.outputDir));
        this.delegates.add(HttpDocumentation.documentHttpRequest(this.outputDir));
        this.delegates.add(HttpDocumentation.documentHttpResponse(this.outputDir));
    }

    public RestDocumentationResultHandler withLinks(LinkDescriptor ... descriptors) {
        return this.withLinks((LinkExtractor)null, descriptors);
    }

    public RestDocumentationResultHandler withLinks(LinkExtractor linkExtractor, LinkDescriptor ... descriptors) {
        this.delegates.add(HypermediaDocumentation.documentLinks(this.outputDir, linkExtractor, descriptors));
        return this;
    }

    public RestDocumentationResultHandler withRequestFields(FieldDescriptor ... descriptors) {
        this.delegates.add(PayloadDocumentation.documentRequestFields(this.outputDir, descriptors));
        return this;
    }

    public RestDocumentationResultHandler withResponseFields(FieldDescriptor ... descriptors) {
        this.delegates.add(PayloadDocumentation.documentResponseFields(this.outputDir, descriptors));
        return this;
    }

    public RestDocumentationResultHandler withQueryParameters(ParameterDescriptor ... descriptors) {
        this.delegates.add(RequestDocumentation.documentQueryParameters(this.outputDir, descriptors));
        return this;
    }

    public void handle(MvcResult result) throws Exception {
        for (ResultHandler delegate : this.delegates) {
            delegate.handle(result);
        }
    }
}

