/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.restassured;

import io.restassured.http.Header;
import io.restassured.response.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.restdocs.operation.OperationResponse;
import org.springframework.restdocs.operation.OperationResponseFactory;
import org.springframework.restdocs.operation.ResponseConverter;
import org.springframework.restdocs.operation.ResponseCookie;

class RestAssuredResponseConverter
implements ResponseConverter<Response> {
    RestAssuredResponseConverter() {
    }

    public OperationResponse convert(Response response) {
        HttpHeaders headers = this.extractHeaders(response);
        Collection<ResponseCookie> cookies = this.extractCookies(response, headers);
        return new OperationResponseFactory().create(response.getStatusCode(), this.extractHeaders(response), this.extractContent(response), cookies);
    }

    private Collection<ResponseCookie> extractCookies(Response response, HttpHeaders headers) {
        if (response.getCookies() == null || response.getCookies().size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<ResponseCookie> cookies = new ArrayList<ResponseCookie>();
        for (Map.Entry cookie : response.getCookies().entrySet()) {
            cookies.add(new ResponseCookie((String)cookie.getKey(), (String)cookie.getValue()));
        }
        return cookies;
    }

    private HttpHeaders extractHeaders(Response response) {
        HttpHeaders httpHeaders = new HttpHeaders();
        for (Header header : response.getHeaders()) {
            httpHeaders.add(header.getName(), header.getValue());
        }
        return httpHeaders;
    }

    private byte[] extractContent(Response response) {
        return response.getBody().asByteArray();
    }
}

