/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.observation;

import io.micrometer.observation.transport.SenderContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class PulsarMessageSenderContext
extends SenderContext<MessageHolder> {
    private final String beanName;
    private final String destination;

    private PulsarMessageSenderContext(MessageHolder messageHolder, String topic, String beanName) {
        super((carrier, key, value) -> messageHolder.property(key, value));
        this.setCarrier(messageHolder);
        this.beanName = beanName;
        this.destination = topic;
    }

    public static PulsarMessageSenderContext newContext(String topic, String beanName) {
        MessageHolder messageHolder = new MessageHolder();
        PulsarMessageSenderContext senderContext = new PulsarMessageSenderContext(messageHolder, topic, beanName);
        return senderContext;
    }

    public Map<String, String> properties() {
        return Objects.requireNonNull((MessageHolder)this.getCarrier(), "Carrier should never be null").properties();
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String getDestination() {
        return this.destination;
    }

    public static final class MessageHolder {
        private final Map<String, String> properties = new HashMap<String, String>();

        private MessageHolder() {
        }

        public void property(String key, String value) {
            this.properties.put(key, value);
        }

        public Map<String, String> properties() {
            return this.properties;
        }
    }
}

