/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.function;

import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.functions.FunctionConfig;
import org.apache.pulsar.common.functions.UpdateOptions;
import org.jspecify.annotations.Nullable;
import org.springframework.pulsar.PulsarException;
import org.springframework.pulsar.function.PulsarFunctionOperations;

public record PulsarFunction(FunctionConfig config, PulsarFunctionOperations.FunctionStopPolicy stopPolicy, @Nullable UpdateOptions updateOptions) implements PulsarFunctionOperations<FunctionConfig>
{
    public PulsarFunction(FunctionConfig config, @Nullable UpdateOptions updateOptions) {
        this(config, PulsarFunctionOperations.FunctionStopPolicy.DELETE, updateOptions);
    }

    @Override
    public String name() {
        return this.config().getName();
    }

    @Override
    public PulsarFunctionOperations.FunctionType type() {
        return PulsarFunctionOperations.FunctionType.FUNCTION;
    }

    @Override
    public String archive() {
        return this.config().getJar();
    }

    @Override
    public FunctionConfig get(PulsarAdmin admin) throws PulsarAdminException {
        return admin.functions().getFunction(this.config().getTenant(), this.config().getNamespace(), this.config().getName());
    }

    @Override
    public void updateWithUrl(PulsarAdmin admin) throws PulsarAdminException {
        admin.functions().updateFunctionWithUrl(this.config(), this.archive(), this.updateOptions());
    }

    @Override
    public void update(PulsarAdmin admin) throws PulsarAdminException {
        admin.functions().updateFunction(this.config(), this.archive(), this.updateOptions());
    }

    @Override
    public void createWithUrl(PulsarAdmin admin) throws PulsarAdminException {
        admin.functions().createFunctionWithUrl(this.config(), this.archive());
    }

    @Override
    public void create(PulsarAdmin admin) throws PulsarAdminException {
        admin.functions().createFunction(this.config(), this.archive());
    }

    @Override
    public void stop(PulsarAdmin admin) {
        try {
            admin.functions().stopFunction(this.config().getTenant(), this.config().getNamespace(), this.config().getName());
        }
        catch (PulsarAdminException e) {
            throw new PulsarException(e.getMessage(), e);
        }
    }

    @Override
    public void delete(PulsarAdmin admin) {
        try {
            admin.functions().deleteFunction(this.config().getTenant(), this.config().getNamespace(), this.config().getName());
        }
        catch (PulsarAdminException e) {
            throw new PulsarException(e.getMessage(), e);
        }
    }
}

