/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.config;

import org.apache.pulsar.client.api.Schema;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.log.LogAccessor;
import org.springframework.pulsar.config.AbstractPulsarListenerEndpoint;
import org.springframework.pulsar.config.PulsarListenerContainerFactory;
import org.springframework.pulsar.config.PulsarListenerEndpoint;
import org.springframework.pulsar.core.PulsarConsumerFactory;
import org.springframework.pulsar.listener.AbstractPulsarMessageListenerContainer;
import org.springframework.pulsar.listener.AckMode;
import org.springframework.pulsar.listener.PulsarContainerProperties;
import org.springframework.pulsar.support.JavaUtils;
import org.springframework.pulsar.support.MessageConverter;

public abstract class AbstractPulsarListenerContainerFactory<C extends AbstractPulsarMessageListenerContainer<T>, T>
implements PulsarListenerContainerFactory,
ApplicationEventPublisherAware,
ApplicationContextAware {
    protected final LogAccessor logger = new LogAccessor(this.getClass());
    private final PulsarConsumerFactory<? super T> consumerFactory;
    private final PulsarContainerProperties containerProperties;
    private @Nullable Boolean autoStartup;
    private @Nullable Integer phase;
    private @Nullable MessageConverter messageConverter;
    private @Nullable Boolean batchListener;
    private @Nullable ApplicationEventPublisher applicationEventPublisher;
    private @Nullable ApplicationContext applicationContext;

    protected AbstractPulsarListenerContainerFactory(PulsarConsumerFactory<? super T> consumerFactory, PulsarContainerProperties containerProperties) {
        this.consumerFactory = consumerFactory;
        this.containerProperties = containerProperties;
    }

    protected PulsarConsumerFactory<? super T> getConsumerFactory() {
        return this.consumerFactory;
    }

    public PulsarContainerProperties getContainerProperties() {
        return this.containerProperties;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public void setBatchListener(Boolean batchListener) {
        this.batchListener = batchListener;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Override
    public C createRegisteredContainer(PulsarListenerEndpoint endpoint) {
        C instance = this.createContainerInstance(endpoint);
        JavaUtils.INSTANCE.acceptIfNotNull(endpoint.getId(), arg_0 -> instance.setBeanName(arg_0));
        if (endpoint instanceof AbstractPulsarListenerEndpoint) {
            this.configureEndpoint((AbstractPulsarListenerEndpoint)endpoint);
        }
        endpoint.setupListenerContainer(instance, this.messageConverter);
        this.initializeContainer(instance, endpoint);
        return instance;
    }

    protected abstract C createContainerInstance(PulsarListenerEndpoint var1);

    private void configureEndpoint(AbstractPulsarListenerEndpoint<C> aplEndpoint) {
        if (aplEndpoint.getBatchListener() == null) {
            JavaUtils.INSTANCE.acceptIfNotNull(this.batchListener, aplEndpoint::setBatchListener);
        }
    }

    protected void initializeContainer(C instance, PulsarListenerEndpoint endpoint) {
        PulsarContainerProperties instanceProperties = ((AbstractPulsarMessageListenerContainer)instance).getContainerProperties();
        if (instanceProperties.getSchemaType() == null) {
            JavaUtils.INSTANCE.acceptIfNotNull(this.containerProperties.getSchemaType(), instanceProperties::setSchemaType);
        }
        if (instanceProperties.getSchema() == null) {
            instanceProperties.setSchema(Schema.BYTES);
        }
        if (instanceProperties.getSubscriptionType() == null) {
            instanceProperties.setSubscriptionType(this.containerProperties.getSubscriptionType());
        }
        if (endpoint.getAckMode() != AckMode.BATCH) {
            instanceProperties.setAckMode(endpoint.getAckMode());
        } else if (this.containerProperties.getAckMode() != AckMode.BATCH) {
            instanceProperties.setAckMode(this.containerProperties.getAckMode());
        }
        Boolean autoStart = endpoint.getAutoStartup();
        if (autoStart != null) {
            ((AbstractPulsarMessageListenerContainer)instance).setAutoStartup(autoStart);
        } else if (this.autoStartup != null) {
            ((AbstractPulsarMessageListenerContainer)instance).setAutoStartup(this.autoStartup);
        }
        instanceProperties.setMaxNumMessages(this.containerProperties.getMaxNumMessages());
        instanceProperties.setMaxNumBytes(this.containerProperties.getMaxNumBytes());
        instanceProperties.setBatchTimeoutMillis(this.containerProperties.getBatchTimeoutMillis());
        instanceProperties.setObservationEnabled(this.containerProperties.isObservationEnabled());
        JavaUtils.INSTANCE.acceptIfNotNull(this.phase, arg_0 -> instance.setPhase(arg_0)).acceptIfNotNull(this.applicationContext, arg_0 -> instance.setApplicationContext(arg_0)).acceptIfNotNull(this.applicationEventPublisher, arg_0 -> instance.setApplicationEventPublisher(arg_0)).acceptIfNotNull(endpoint.getConsumerProperties(), ((AbstractPulsarMessageListenerContainer)instance).getContainerProperties()::setPulsarConsumerProperties);
        instanceProperties.updateContainerProperties();
    }
}

