/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.support.header;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.springframework.util.ClassUtils;

public final class JacksonUtils {
    private static final ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
    private static final boolean JACKSON_PRESENT = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)classLoader) && ClassUtils.isPresent((String)"com.fasterxml.jackson.core.JsonGenerator", (ClassLoader)classLoader);
    private static final boolean JDK8_MODULE_PRESENT = ClassUtils.isPresent((String)"com.fasterxml.jackson.datatype.jdk8.Jdk8Module", null);
    private static final boolean JAVA_TIME_MODULE_PRESENT = ClassUtils.isPresent((String)"com.fasterxml.jackson.datatype.jsr310.JavaTimeModule", null);
    private static final boolean JODA_MODULE_PRESENT = ClassUtils.isPresent((String)"com.fasterxml.jackson.datatype.joda.JodaModule", null);

    public static boolean isJacksonPresent() {
        return JACKSON_PRESENT;
    }

    public static ObjectMapper enhancedObjectMapper() {
        ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.DEFAULT_VIEW_INCLUSION, false)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).build();
        if (JDK8_MODULE_PRESENT) {
            objectMapper.registerModule(Jdk8ModuleProvider.MODULE);
        }
        if (JAVA_TIME_MODULE_PRESENT) {
            objectMapper.registerModule(JavaTimeModuleProvider.MODULE);
        }
        if (JODA_MODULE_PRESENT) {
            objectMapper.registerModule(JodaModuleProvider.MODULE);
        }
        return objectMapper;
    }

    private JacksonUtils() {
    }

    private static final class Jdk8ModuleProvider {
        static final Module MODULE = new Jdk8Module();

        private Jdk8ModuleProvider() {
        }
    }

    private static final class JavaTimeModuleProvider {
        static final Module MODULE = new JavaTimeModule();

        private JavaTimeModuleProvider() {
        }
    }

    private static final class JodaModuleProvider {
        static final Module MODULE = new JodaModule();

        private JodaModuleProvider() {
        }
    }
}

