/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.ProducerBuilderImpl;
import org.springframework.core.log.LogAccessor;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.core.DefaultTopicResolver;
import org.springframework.pulsar.core.ProducerBuilderCustomizer;
import org.springframework.pulsar.core.PulsarProducerFactory;
import org.springframework.pulsar.core.TopicResolver;
import org.springframework.util.CollectionUtils;

public class DefaultPulsarProducerFactory<T>
implements PulsarProducerFactory<T> {
    private final LogAccessor logger = new LogAccessor(this.getClass());
    private final PulsarClient pulsarClient;
    @Nullable
    private final String defaultTopic;
    @Nullable
    private final List<ProducerBuilderCustomizer<T>> defaultConfigCustomizers;
    private final TopicResolver topicResolver;

    public DefaultPulsarProducerFactory(PulsarClient pulsarClient) {
        this(pulsarClient, null, null, new DefaultTopicResolver());
    }

    public DefaultPulsarProducerFactory(PulsarClient pulsarClient, @Nullable String defaultTopic) {
        this(pulsarClient, defaultTopic, null, new DefaultTopicResolver());
    }

    public DefaultPulsarProducerFactory(PulsarClient pulsarClient, @Nullable String defaultTopic, @Nullable List<ProducerBuilderCustomizer<T>> defaultConfigCustomizers) {
        this(pulsarClient, defaultTopic, defaultConfigCustomizers, new DefaultTopicResolver());
    }

    public DefaultPulsarProducerFactory(PulsarClient pulsarClient, @Nullable String defaultTopic, @Nullable List<ProducerBuilderCustomizer<T>> defaultConfigCustomizers, TopicResolver topicResolver) {
        this.pulsarClient = pulsarClient;
        this.defaultTopic = defaultTopic;
        this.defaultConfigCustomizers = defaultConfigCustomizers;
        this.topicResolver = topicResolver;
    }

    @Override
    public Producer<T> createProducer(Schema<T> schema, @Nullable String topic) throws PulsarClientException {
        return this.doCreateProducer(schema, topic, null, null);
    }

    @Override
    public Producer<T> createProducer(Schema<T> schema, @Nullable String topic, @Nullable ProducerBuilderCustomizer<T> customizer) throws PulsarClientException {
        return this.doCreateProducer(schema, topic, null, customizer != null ? Collections.singletonList(customizer) : null);
    }

    @Override
    public Producer<T> createProducer(Schema<T> schema, @Nullable String topic, @Nullable Collection<String> encryptionKeys, @Nullable List<ProducerBuilderCustomizer<T>> customizers) throws PulsarClientException {
        return this.doCreateProducer(schema, topic, encryptionKeys, customizers);
    }

    protected Producer<T> doCreateProducer(Schema<T> schema, @Nullable String topic, @Nullable Collection<String> encryptionKeys, @Nullable List<ProducerBuilderCustomizer<T>> customizers) throws PulsarClientException {
        Objects.requireNonNull(schema, "Schema must be specified");
        String resolvedTopic = this.resolveTopicName(topic);
        this.logger.trace(() -> "Creating producer for '%s' topic".formatted(resolvedTopic));
        ProducerBuilder producerBuilder = this.pulsarClient.newProducer(schema);
        if (!CollectionUtils.isEmpty(this.defaultConfigCustomizers)) {
            this.defaultConfigCustomizers.forEach(customizer -> customizer.customize(producerBuilder));
        }
        producerBuilder.topic(resolvedTopic);
        this.maybeSetEncryptionKeys(producerBuilder, encryptionKeys);
        if (!CollectionUtils.isEmpty(customizers)) {
            customizers.forEach(c -> c.customize(producerBuilder));
        }
        producerBuilder.topic(resolvedTopic);
        return producerBuilder.create();
    }

    protected String resolveTopicName(String userSpecifiedTopic) {
        return this.topicResolver.resolveTopic(userSpecifiedTopic, this::getDefaultTopic).orElseThrow();
    }

    @Override
    public String getDefaultTopic() {
        return this.defaultTopic;
    }

    private void maybeSetEncryptionKeys(ProducerBuilder<T> builder, @Nullable Collection<String> encryptionKeys) {
        if (encryptionKeys != null) {
            ProducerBuilderImpl builderImpl = (ProducerBuilderImpl)builder;
            builderImpl.getConf().setEncryptionKeys(new HashSet<String>(encryptionKeys));
        }
    }
}

