/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.plugin.metadata;

import org.springframework.plugin.metadata.PluginMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class SimplePluginMetadata
implements PluginMetadata {
    private final String name;
    private final String version;

    public SimplePluginMetadata(String name, String version) {
        Assert.hasText((String)name, (String)"Name must not be null or empty!");
        Assert.hasText((String)version, (String)"Version must not be null or empty!");
        this.name = name;
        this.version = version;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return String.format("%s:%s", this.getName(), this.getVersion());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PluginMetadata)) {
            return false;
        }
        PluginMetadata that = (PluginMetadata)obj;
        boolean sameName = ObjectUtils.nullSafeEquals((Object)this.getName(), (Object)that.getName());
        boolean sameVersion = ObjectUtils.nullSafeEquals((Object)this.getName(), (Object)that.getName());
        return sameName && sameVersion;
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object)this.name) + ObjectUtils.nullSafeHashCode((Object)this.version);
    }
}

