/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.io;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.osgi.io.OsgiBundleResource;
import org.springframework.osgi.io.OsgiBundleResourceLoader;
import org.springframework.osgi.io.internal.OsgiResourceUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class OsgiBundleResourcePatternResolver
extends PathMatchingResourcePatternResolver {
    private static final Log logger = LogFactory.getLog((Class)OsgiBundleResourcePatternResolver.class);
    private Bundle bundle;
    private static final String FOLDER_SEPARATOR = "/";
    private static final String FOLDER_WILDCARD = "**";

    public OsgiBundleResourcePatternResolver(Bundle bundle) {
        this((ResourceLoader)new OsgiBundleResourceLoader(bundle));
    }

    public OsgiBundleResourcePatternResolver(ResourceLoader resourceLoader) {
        super(resourceLoader);
        if (resourceLoader instanceof OsgiBundleResourceLoader) {
            this.bundle = ((OsgiBundleResourceLoader)resourceLoader).getBundle();
        }
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        Assert.notNull((Object)locationPattern, (String)"Location pattern must not be null");
        int type = OsgiResourceUtils.getSearchType(locationPattern);
        if (this.getPathMatcher().isPattern(locationPattern)) {
            if (type == 2) {
                throw new IllegalArgumentException("pattern matching is unsupported for class space lookups");
            }
            return this.findPathMatchingResources(locationPattern, type);
        }
        Resource[] result = null;
        if (type == 0 || type == 1) {
            OsgiBundleResource resource = new OsgiBundleResource(this.bundle, locationPattern);
            URL[] urls = resource.getAllUrlsFromBundleSpace(locationPattern);
            result = OsgiResourceUtils.convertURLArraytoResourceArray(urls);
        } else if (type == 2) {
            String location = OsgiResourceUtils.stripPrefix(locationPattern);
            result = OsgiResourceUtils.convertURLEnumerationToResourceArray(this.bundle.getResources(location));
        }
        if (ObjectUtils.isEmpty(result)) {
            result = new Resource[]{this.getResourceLoader().getResource(locationPattern)};
        }
        return result;
    }

    private Resource[] findPathMatchingResources(String locationPattern, int searchType) throws IOException {
        String rootDirPath = this.determineRootDir(locationPattern);
        String subPattern = locationPattern.substring(rootDirPath.length());
        Resource[] rootDirResources = this.getResources(rootDirPath);
        LinkedHashSet result = new LinkedHashSet(16);
        for (int i = 0; i < rootDirResources.length; ++i) {
            Resource rootDirResource = rootDirResources[i];
            if (this.isJarResource(rootDirResource)) {
                result.addAll(this.doFindPathMatchingJarResources(rootDirResource, subPattern));
                continue;
            }
            result.addAll(this.doFindPathMatchingFileResources(rootDirResource, subPattern, searchType));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Resolved location pattern [" + locationPattern + "] to resources " + result));
        }
        return result.toArray(new Resource[result.size()]);
    }

    private Set doFindPathMatchingFileResources(Resource rootDirResource, String subPattern, int searchType) throws IOException {
        String rootPath = null;
        if (rootDirResource instanceof OsgiBundleResource) {
            OsgiBundleResource bundleResource = (OsgiBundleResource)rootDirResource;
            rootPath = bundleResource.getPath();
            searchType = bundleResource.getSearchType();
        } else if (rootDirResource instanceof UrlResource) {
            rootPath = rootDirResource.getURL().getPath();
        }
        if (rootPath != null) {
            String cleanPath = OsgiResourceUtils.stripPrefix(rootPath);
            String fullPattern = cleanPath + subPattern;
            LinkedHashSet result = new LinkedHashSet(16);
            this.doRetrieveMatchingBundleEntries(this.bundle, fullPattern, cleanPath, result, searchType);
            return result;
        }
        return super.doFindPathMatchingFileResources(rootDirResource, subPattern);
    }

    private void doRetrieveMatchingBundleEntries(Bundle bundle, String fullPattern, String dir, Set result, int searchType) throws IOException {
        Enumeration candidates;
        switch (searchType) {
            case 0: 
            case 1: {
                candidates = bundle.findEntries(dir, null, false);
                break;
            }
            case 4: {
                candidates = bundle.getEntryPaths(dir);
                break;
            }
            case 2: {
                throw new IllegalArgumentException("class space does not support pattern matching");
            }
            default: {
                throw new IllegalArgumentException("unknown searchType " + searchType);
            }
        }
        if (candidates != null) {
            boolean dirDepthNotFixed;
            boolean bl = dirDepthNotFixed = fullPattern.indexOf(FOLDER_WILDCARD) != -1;
            while (candidates.hasMoreElements()) {
                int dirIndex;
                Object path = candidates.nextElement();
                String currPath = path instanceof String ? this.handleString((String)path) : this.handleURL((URL)path);
                if (!currPath.startsWith(dir) && (dirIndex = currPath.indexOf(dir)) != -1) {
                    currPath = currPath.substring(dirIndex);
                }
                if (currPath.endsWith(FOLDER_SEPARATOR) && (dirDepthNotFixed || StringUtils.countOccurrencesOf((String)currPath, (String)FOLDER_SEPARATOR) < StringUtils.countOccurrencesOf((String)fullPattern, (String)FOLDER_SEPARATOR))) {
                    this.doRetrieveMatchingBundleEntries(bundle, fullPattern, currPath, result, searchType);
                }
                if (!this.getPathMatcher().match(fullPattern, currPath)) continue;
                if (path instanceof URL) {
                    result.add(new UrlResource((URL)path));
                    continue;
                }
                result.add(new OsgiBundleResource(bundle, currPath));
            }
        }
    }

    private String handleURL(URL path) {
        return path.getPath();
    }

    private String handleString(String path) {
        return FOLDER_SEPARATOR.concat(path);
    }
}

