/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.observability;

import java.util.function.Consumer;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.scheduling.annotation.AsyncAnnotationAdvisor;

class ModuleTracingSupport
implements BeanClassLoaderAware {
    private ClassLoader classLoader;

    ModuleTracingSupport() {
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected final Object addAdvisor(Object bean, Advisor advisor) {
        return this.addAdvisor(bean, advisor, __ -> {});
    }

    protected final Object addAdvisor(Object bean, Advisor advisor, Consumer<ProxyFactory> customizer) {
        if (bean instanceof Advised) {
            Advised advised = (Advised)bean;
            advised.addAdvisor(ModuleTracingSupport.asyncAdvisorIndex(advised) + 1, advisor);
            return bean;
        }
        ProxyFactory factory = new ProxyFactory(bean);
        customizer.accept(factory);
        factory.addAdvisor(advisor);
        return factory.getProxy(this.classLoader);
    }

    private static int asyncAdvisorIndex(Advised advised) {
        Advisor[] advisors = advised.getAdvisors();
        for (int i = 0; i < advised.getAdvisorCount(); ++i) {
            if (!(advisors[i] instanceof AsyncAnnotationAdvisor)) continue;
            return i;
        }
        return -1;
    }
}

