/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.moments;

import java.time.LocalDate;
import java.time.Month;
import java.time.Year;
import java.util.Objects;
import org.jmolecules.event.types.DomainEvent;
import org.springframework.util.Assert;

public class YearHasPassed
implements DomainEvent {
    private final Year year;

    private YearHasPassed(Year year) {
        Assert.notNull((Object)year, (String)"Year must not be null!");
        this.year = year;
    }

    public static YearHasPassed of(Year year) {
        return new YearHasPassed(year);
    }

    public static YearHasPassed of(int year) {
        return YearHasPassed.of(Year.of(year));
    }

    public Year getYear() {
        return this.year;
    }

    LocalDate getStartDate() {
        return LocalDate.of(this.year.getValue(), Month.JANUARY, 1);
    }

    LocalDate getEndDate() {
        return LocalDate.of(this.year.getValue(), Month.DECEMBER, 31);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof YearHasPassed)) {
            return false;
        }
        YearHasPassed that = (YearHasPassed)obj;
        return Objects.equals(this.year, that.year);
    }

    public int hashCode() {
        return Objects.hash(this.year);
    }
}

