/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.aptk.tools.filter.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import org.springframework.modulith.aptk.tools.Utilities;
import org.springframework.modulith.aptk.tools.matcher.CriteriaMatcher;
import org.springframework.modulith.aptk.tools.validator.impl.CriteriaElementValidatorImpl;

public class CriteriaElementFilterImpl {
    @SafeVarargs
    private static <ELEMENT extends Element, CRITERIA, MATCHER extends CriteriaMatcher<ELEMENT, CRITERIA>> List<ELEMENT> filterByValidatorKind(CriteriaElementValidatorImpl.ValidatorKind validatorKind, MATCHER matcher, boolean invert, List<ELEMENT> elements, CRITERIA ... criteriaToCheck) {
        if (elements == null || matcher == null) {
            return new ArrayList();
        }
        if (criteriaToCheck == null || criteriaToCheck.length == 0) {
            if (!invert) {
                return elements;
            }
            return new ArrayList();
        }
        Set<CRITERIA> criteriaToCheckSet = Utilities.convertArrayToSet(criteriaToCheck);
        if (criteriaToCheckSet.size() == 0) {
            return elements;
        }
        ArrayList<Element> result = new ArrayList<Element>();
        for (Element element : elements) {
            boolean validatorResult = CriteriaElementValidatorImpl.INSTANCE.validateByValidatorKind(validatorKind, matcher, element, criteriaToCheck);
            if ((invert || !validatorResult) && (!invert || validatorResult)) continue;
            result.add(element);
        }
        return result;
    }

    @SafeVarargs
    public static <ELEMENT extends Element, CRITERIA, MATCHER extends CriteriaMatcher<ELEMENT, CRITERIA>> List<ELEMENT> filterByOneOf(MATCHER matcher, boolean invert, List<ELEMENT> elements, CRITERIA ... criteriaToCheck) {
        return CriteriaElementFilterImpl.filterByValidatorKind(CriteriaElementValidatorImpl.ValidatorKind.HAS_ONE_OF, matcher, invert, elements, criteriaToCheck);
    }

    @SafeVarargs
    public static <ELEMENT extends Element, CRITERIA, MATCHER extends CriteriaMatcher<ELEMENT, CRITERIA>> List<ELEMENT> filterByNoneOf(MATCHER matcher, boolean invert, List<ELEMENT> elements, CRITERIA ... criteriaToCheck) {
        return CriteriaElementFilterImpl.filterByValidatorKind(CriteriaElementValidatorImpl.ValidatorKind.HAS_NONE_OF, matcher, invert, elements, criteriaToCheck);
    }

    @SafeVarargs
    public static <ELEMENT extends Element, CRITERIA, MATCHER extends CriteriaMatcher<ELEMENT, CRITERIA>> List<ELEMENT> filterByAllOf(MATCHER matcher, boolean invert, List<ELEMENT> elements, CRITERIA ... criteriaToCheck) {
        return CriteriaElementFilterImpl.filterByValidatorKind(CriteriaElementValidatorImpl.ValidatorKind.HAS_ALL_OF, matcher, invert, elements, criteriaToCheck);
    }

    @SafeVarargs
    public static <ELEMENT extends Element, CRITERIA, MATCHER extends CriteriaMatcher<ELEMENT, CRITERIA>> List<ELEMENT> filterByAtLeastOneOf(MATCHER matcher, boolean invert, List<ELEMENT> elements, CRITERIA ... characteristicsToCheck) {
        return CriteriaElementFilterImpl.filterByValidatorKind(CriteriaElementValidatorImpl.ValidatorKind.HAS_AT_LEAST_ONE_OF, matcher, invert, elements, characteristicsToCheck);
    }
}

