/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.actuator.autoconfigure;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.modulith.core.util.ApplicationModulesExporter;
import org.springframework.modulith.runtime.ApplicationModulesRuntime;

class ApplicationModulesFileGeneratingProcessor
implements BeanFactoryInitializationAotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationModulesFileGeneratingProcessor.class);

    ApplicationModulesFileGeneratingProcessor() {
    }

    public BeanFactoryInitializationAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        return (context, __) -> {
            ApplicationModulesRuntime runtime = (ApplicationModulesRuntime)beanFactory.getBean(ApplicationModulesRuntime.class);
            ApplicationModulesExporter exporter = new ApplicationModulesExporter(runtime.get());
            String location = "META-INF/spring-modulith/application-modules.json";
            LOGGER.info("Generating application modules information to {}", (Object)location);
            context.getRuntimeHints().resources().registerPattern(location);
            context.getGeneratedFiles().addResourceFile(location, (CharSequence)exporter.toJson());
        };
    }
}

