/*
 * Copyright 2010-2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.mobile.device.annotation;

import org.springframework.lang.Nullable;
import org.springframework.mobile.device.DeviceResolver;

/**
 * Defines callback methods to customize the Java-based configuration for
 * Spring Mobile enabled via {@code @EnableDeviceResolver}.
 *
 * <p>{@code @EnableDeviceResolver}-annotated configuration classes may implement
 * this interface to be called back and given a chance to customize the
 * default configuration.
 *
 * @author Roy Clarkson
 * @since 2.0
 */
public interface DeviceResolverConfigurer {

	@Nullable
	default DeviceResolver getDeviceResolver() {
		return null;
	}

}
